/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.LongTermPricingEntryListCopier;
import software.amazon.awssdk.services.snowball.model.LongTermPricingListEntry;
import software.amazon.awssdk.services.snowball.model.SnowballResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLongTermPricingResponse
extends SnowballResponse
implements ToCopyableBuilder<Builder, ListLongTermPricingResponse> {
    private static final SdkField<List<LongTermPricingListEntry>> LONG_TERM_PRICING_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LongTermPricingEntries").getter(ListLongTermPricingResponse.getter(ListLongTermPricingResponse::longTermPricingEntries)).setter(ListLongTermPricingResponse.setter(Builder::longTermPricingEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LongTermPricingListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLongTermPricingResponse.getter(ListLongTermPricingResponse::nextToken)).setter(ListLongTermPricingResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LONG_TERM_PRICING_ENTRIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLongTermPricingResponse.memberNameToFieldInitializer();
    private final List<LongTermPricingListEntry> longTermPricingEntries;
    private final String nextToken;

    private ListLongTermPricingResponse(BuilderImpl builder) {
        super(builder);
        this.longTermPricingEntries = builder.longTermPricingEntries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLongTermPricingEntries() {
        return this.longTermPricingEntries != null && !(this.longTermPricingEntries instanceof SdkAutoConstructList);
    }

    public final List<LongTermPricingListEntry> longTermPricingEntries() {
        return this.longTermPricingEntries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLongTermPricingEntries() ? this.longTermPricingEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLongTermPricingResponse)) {
            return false;
        }
        ListLongTermPricingResponse other = (ListLongTermPricingResponse)((Object)obj);
        return this.hasLongTermPricingEntries() == other.hasLongTermPricingEntries() && Objects.equals(this.longTermPricingEntries(), other.longTermPricingEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLongTermPricingResponse").add("LongTermPricingEntries", this.hasLongTermPricingEntries() ? this.longTermPricingEntries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LongTermPricingEntries": {
                return Optional.ofNullable(clazz.cast(this.longTermPricingEntries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LongTermPricingEntries", LONG_TERM_PRICING_ENTRIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLongTermPricingResponse, T> g) {
        return obj -> g.apply((ListLongTermPricingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballResponse.BuilderImpl
    implements Builder {
        private List<LongTermPricingListEntry> longTermPricingEntries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLongTermPricingResponse model) {
            super(model);
            this.longTermPricingEntries(model.longTermPricingEntries);
            this.nextToken(model.nextToken);
        }

        public final List<LongTermPricingListEntry.Builder> getLongTermPricingEntries() {
            List<LongTermPricingListEntry.Builder> result = LongTermPricingEntryListCopier.copyToBuilder(this.longTermPricingEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLongTermPricingEntries(Collection<LongTermPricingListEntry.BuilderImpl> longTermPricingEntries) {
            this.longTermPricingEntries = LongTermPricingEntryListCopier.copyFromBuilder(longTermPricingEntries);
        }

        @Override
        public final Builder longTermPricingEntries(Collection<LongTermPricingListEntry> longTermPricingEntries) {
            this.longTermPricingEntries = LongTermPricingEntryListCopier.copy(longTermPricingEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder longTermPricingEntries(LongTermPricingListEntry ... longTermPricingEntries) {
            this.longTermPricingEntries(Arrays.asList(longTermPricingEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder longTermPricingEntries(Consumer<LongTermPricingListEntry.Builder> ... longTermPricingEntries) {
            this.longTermPricingEntries(Stream.of(longTermPricingEntries).map(c -> (LongTermPricingListEntry)((LongTermPricingListEntry.Builder)LongTermPricingListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLongTermPricingResponse build() {
            return new ListLongTermPricingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SnowballResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLongTermPricingResponse> {
        public Builder longTermPricingEntries(Collection<LongTermPricingListEntry> var1);

        public Builder longTermPricingEntries(LongTermPricingListEntry ... var1);

        public Builder longTermPricingEntries(Consumer<LongTermPricingListEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

