/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.LongTermPricingAssociatedJobIdListCopier;
import software.amazon.awssdk.services.snowball.model.LongTermPricingType;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LongTermPricingListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LongTermPricingListEntry> {
    private static final SdkField<String> LONG_TERM_PRICING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LongTermPricingId").getter(LongTermPricingListEntry.getter(LongTermPricingListEntry::longTermPricingId)).setter(LongTermPricingListEntry.setter(Builder::longTermPricingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingId").build()}).build();
    private static final SdkField<Instant> LONG_TERM_PRICING_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LongTermPricingEndDate").getter(LongTermPricingListEntry.getter(LongTermPricingListEntry::longTermPricingEndDate)).setter(LongTermPricingListEntry.setter(Builder::longTermPricingEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingEndDate").build()}).build();
    private static final SdkField<Instant> LONG_TERM_PRICING_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LongTermPricingStartDate").getter(LongTermPricingListEntry.getter(LongTermPricingListEntry::longTermPricingStartDate)).setter(LongTermPricingListEntry.setter(Builder::longTermPricingStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingStartDate").build()}).build();
    private static final SdkField<String> LONG_TERM_PRICING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LongTermPricingType").getter(LongTermPricingListEntry.getter(LongTermPricingListEntry::longTermPricingTypeAsString)).setter(LongTermPricingListEntry.setter(Builder::longTermPricingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingType").build()}).build();
    private static final SdkField<String> CURRENT_ACTIVE_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentActiveJob").getter(LongTermPricingListEntry.getter(LongTermPricingListEntry::currentActiveJob)).setter(LongTermPricingListEntry.setter(Builder::currentActiveJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentActiveJob").build()}).build();
    private static final SdkField<String> REPLACEMENT_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplacementJob").getter(LongTermPricingListEntry.getter(LongTermPricingListEntry::replacementJob)).setter(LongTermPricingListEntry.setter(Builder::replacementJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementJob").build()}).build();
    private static final SdkField<Boolean> IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsLongTermPricingAutoRenew").getter(LongTermPricingListEntry.getter(LongTermPricingListEntry::isLongTermPricingAutoRenew)).setter(LongTermPricingListEntry.setter(Builder::isLongTermPricingAutoRenew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLongTermPricingAutoRenew").build()}).build();
    private static final SdkField<String> LONG_TERM_PRICING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LongTermPricingStatus").getter(LongTermPricingListEntry.getter(LongTermPricingListEntry::longTermPricingStatus)).setter(LongTermPricingListEntry.setter(Builder::longTermPricingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingStatus").build()}).build();
    private static final SdkField<String> SNOWBALL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnowballType").getter(LongTermPricingListEntry.getter(LongTermPricingListEntry::snowballTypeAsString)).setter(LongTermPricingListEntry.setter(Builder::snowballType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballType").build()}).build();
    private static final SdkField<List<String>> JOB_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobIds").getter(LongTermPricingListEntry.getter(LongTermPricingListEntry::jobIds)).setter(LongTermPricingListEntry.setter(Builder::jobIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LONG_TERM_PRICING_ID_FIELD, LONG_TERM_PRICING_END_DATE_FIELD, LONG_TERM_PRICING_START_DATE_FIELD, LONG_TERM_PRICING_TYPE_FIELD, CURRENT_ACTIVE_JOB_FIELD, REPLACEMENT_JOB_FIELD, IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD, LONG_TERM_PRICING_STATUS_FIELD, SNOWBALL_TYPE_FIELD, JOB_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LongTermPricingListEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String longTermPricingId;
    private final Instant longTermPricingEndDate;
    private final Instant longTermPricingStartDate;
    private final String longTermPricingType;
    private final String currentActiveJob;
    private final String replacementJob;
    private final Boolean isLongTermPricingAutoRenew;
    private final String longTermPricingStatus;
    private final String snowballType;
    private final List<String> jobIds;

    private LongTermPricingListEntry(BuilderImpl builder) {
        this.longTermPricingId = builder.longTermPricingId;
        this.longTermPricingEndDate = builder.longTermPricingEndDate;
        this.longTermPricingStartDate = builder.longTermPricingStartDate;
        this.longTermPricingType = builder.longTermPricingType;
        this.currentActiveJob = builder.currentActiveJob;
        this.replacementJob = builder.replacementJob;
        this.isLongTermPricingAutoRenew = builder.isLongTermPricingAutoRenew;
        this.longTermPricingStatus = builder.longTermPricingStatus;
        this.snowballType = builder.snowballType;
        this.jobIds = builder.jobIds;
    }

    public final String longTermPricingId() {
        return this.longTermPricingId;
    }

    public final Instant longTermPricingEndDate() {
        return this.longTermPricingEndDate;
    }

    public final Instant longTermPricingStartDate() {
        return this.longTermPricingStartDate;
    }

    public final LongTermPricingType longTermPricingType() {
        return LongTermPricingType.fromValue(this.longTermPricingType);
    }

    public final String longTermPricingTypeAsString() {
        return this.longTermPricingType;
    }

    public final String currentActiveJob() {
        return this.currentActiveJob;
    }

    public final String replacementJob() {
        return this.replacementJob;
    }

    public final Boolean isLongTermPricingAutoRenew() {
        return this.isLongTermPricingAutoRenew;
    }

    public final String longTermPricingStatus() {
        return this.longTermPricingStatus;
    }

    public final SnowballType snowballType() {
        return SnowballType.fromValue(this.snowballType);
    }

    public final String snowballTypeAsString() {
        return this.snowballType;
    }

    public final boolean hasJobIds() {
        return this.jobIds != null && !(this.jobIds instanceof SdkAutoConstructList);
    }

    public final List<String> jobIds() {
        return this.jobIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.longTermPricingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.longTermPricingEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.longTermPricingStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.longTermPricingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentActiveJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.replacementJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLongTermPricingAutoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(this.longTermPricingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobIds() ? this.jobIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LongTermPricingListEntry)) {
            return false;
        }
        LongTermPricingListEntry other = (LongTermPricingListEntry)obj;
        return Objects.equals(this.longTermPricingId(), other.longTermPricingId()) && Objects.equals(this.longTermPricingEndDate(), other.longTermPricingEndDate()) && Objects.equals(this.longTermPricingStartDate(), other.longTermPricingStartDate()) && Objects.equals(this.longTermPricingTypeAsString(), other.longTermPricingTypeAsString()) && Objects.equals(this.currentActiveJob(), other.currentActiveJob()) && Objects.equals(this.replacementJob(), other.replacementJob()) && Objects.equals(this.isLongTermPricingAutoRenew(), other.isLongTermPricingAutoRenew()) && Objects.equals(this.longTermPricingStatus(), other.longTermPricingStatus()) && Objects.equals(this.snowballTypeAsString(), other.snowballTypeAsString()) && this.hasJobIds() == other.hasJobIds() && Objects.equals(this.jobIds(), other.jobIds());
    }

    public final String toString() {
        return ToString.builder((String)"LongTermPricingListEntry").add("LongTermPricingId", (Object)this.longTermPricingId()).add("LongTermPricingEndDate", (Object)this.longTermPricingEndDate()).add("LongTermPricingStartDate", (Object)this.longTermPricingStartDate()).add("LongTermPricingType", (Object)this.longTermPricingTypeAsString()).add("CurrentActiveJob", (Object)this.currentActiveJob()).add("ReplacementJob", (Object)this.replacementJob()).add("IsLongTermPricingAutoRenew", (Object)this.isLongTermPricingAutoRenew()).add("LongTermPricingStatus", (Object)this.longTermPricingStatus()).add("SnowballType", (Object)this.snowballTypeAsString()).add("JobIds", this.hasJobIds() ? this.jobIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LongTermPricingId": {
                return Optional.ofNullable(clazz.cast(this.longTermPricingId()));
            }
            case "LongTermPricingEndDate": {
                return Optional.ofNullable(clazz.cast(this.longTermPricingEndDate()));
            }
            case "LongTermPricingStartDate": {
                return Optional.ofNullable(clazz.cast(this.longTermPricingStartDate()));
            }
            case "LongTermPricingType": {
                return Optional.ofNullable(clazz.cast(this.longTermPricingTypeAsString()));
            }
            case "CurrentActiveJob": {
                return Optional.ofNullable(clazz.cast(this.currentActiveJob()));
            }
            case "ReplacementJob": {
                return Optional.ofNullable(clazz.cast(this.replacementJob()));
            }
            case "IsLongTermPricingAutoRenew": {
                return Optional.ofNullable(clazz.cast(this.isLongTermPricingAutoRenew()));
            }
            case "LongTermPricingStatus": {
                return Optional.ofNullable(clazz.cast(this.longTermPricingStatus()));
            }
            case "SnowballType": {
                return Optional.ofNullable(clazz.cast(this.snowballTypeAsString()));
            }
            case "JobIds": {
                return Optional.ofNullable(clazz.cast(this.jobIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LongTermPricingId", LONG_TERM_PRICING_ID_FIELD);
        map.put("LongTermPricingEndDate", LONG_TERM_PRICING_END_DATE_FIELD);
        map.put("LongTermPricingStartDate", LONG_TERM_PRICING_START_DATE_FIELD);
        map.put("LongTermPricingType", LONG_TERM_PRICING_TYPE_FIELD);
        map.put("CurrentActiveJob", CURRENT_ACTIVE_JOB_FIELD);
        map.put("ReplacementJob", REPLACEMENT_JOB_FIELD);
        map.put("IsLongTermPricingAutoRenew", IS_LONG_TERM_PRICING_AUTO_RENEW_FIELD);
        map.put("LongTermPricingStatus", LONG_TERM_PRICING_STATUS_FIELD);
        map.put("SnowballType", SNOWBALL_TYPE_FIELD);
        map.put("JobIds", JOB_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LongTermPricingListEntry, T> g) {
        return obj -> g.apply((LongTermPricingListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String longTermPricingId;
        private Instant longTermPricingEndDate;
        private Instant longTermPricingStartDate;
        private String longTermPricingType;
        private String currentActiveJob;
        private String replacementJob;
        private Boolean isLongTermPricingAutoRenew;
        private String longTermPricingStatus;
        private String snowballType;
        private List<String> jobIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LongTermPricingListEntry model) {
            this.longTermPricingId(model.longTermPricingId);
            this.longTermPricingEndDate(model.longTermPricingEndDate);
            this.longTermPricingStartDate(model.longTermPricingStartDate);
            this.longTermPricingType(model.longTermPricingType);
            this.currentActiveJob(model.currentActiveJob);
            this.replacementJob(model.replacementJob);
            this.isLongTermPricingAutoRenew(model.isLongTermPricingAutoRenew);
            this.longTermPricingStatus(model.longTermPricingStatus);
            this.snowballType(model.snowballType);
            this.jobIds(model.jobIds);
        }

        public final String getLongTermPricingId() {
            return this.longTermPricingId;
        }

        public final void setLongTermPricingId(String longTermPricingId) {
            this.longTermPricingId = longTermPricingId;
        }

        @Override
        public final Builder longTermPricingId(String longTermPricingId) {
            this.longTermPricingId = longTermPricingId;
            return this;
        }

        public final Instant getLongTermPricingEndDate() {
            return this.longTermPricingEndDate;
        }

        public final void setLongTermPricingEndDate(Instant longTermPricingEndDate) {
            this.longTermPricingEndDate = longTermPricingEndDate;
        }

        @Override
        public final Builder longTermPricingEndDate(Instant longTermPricingEndDate) {
            this.longTermPricingEndDate = longTermPricingEndDate;
            return this;
        }

        public final Instant getLongTermPricingStartDate() {
            return this.longTermPricingStartDate;
        }

        public final void setLongTermPricingStartDate(Instant longTermPricingStartDate) {
            this.longTermPricingStartDate = longTermPricingStartDate;
        }

        @Override
        public final Builder longTermPricingStartDate(Instant longTermPricingStartDate) {
            this.longTermPricingStartDate = longTermPricingStartDate;
            return this;
        }

        public final String getLongTermPricingType() {
            return this.longTermPricingType;
        }

        public final void setLongTermPricingType(String longTermPricingType) {
            this.longTermPricingType = longTermPricingType;
        }

        @Override
        public final Builder longTermPricingType(String longTermPricingType) {
            this.longTermPricingType = longTermPricingType;
            return this;
        }

        @Override
        public final Builder longTermPricingType(LongTermPricingType longTermPricingType) {
            this.longTermPricingType(longTermPricingType == null ? null : longTermPricingType.toString());
            return this;
        }

        public final String getCurrentActiveJob() {
            return this.currentActiveJob;
        }

        public final void setCurrentActiveJob(String currentActiveJob) {
            this.currentActiveJob = currentActiveJob;
        }

        @Override
        public final Builder currentActiveJob(String currentActiveJob) {
            this.currentActiveJob = currentActiveJob;
            return this;
        }

        public final String getReplacementJob() {
            return this.replacementJob;
        }

        public final void setReplacementJob(String replacementJob) {
            this.replacementJob = replacementJob;
        }

        @Override
        public final Builder replacementJob(String replacementJob) {
            this.replacementJob = replacementJob;
            return this;
        }

        public final Boolean getIsLongTermPricingAutoRenew() {
            return this.isLongTermPricingAutoRenew;
        }

        public final void setIsLongTermPricingAutoRenew(Boolean isLongTermPricingAutoRenew) {
            this.isLongTermPricingAutoRenew = isLongTermPricingAutoRenew;
        }

        @Override
        public final Builder isLongTermPricingAutoRenew(Boolean isLongTermPricingAutoRenew) {
            this.isLongTermPricingAutoRenew = isLongTermPricingAutoRenew;
            return this;
        }

        public final String getLongTermPricingStatus() {
            return this.longTermPricingStatus;
        }

        public final void setLongTermPricingStatus(String longTermPricingStatus) {
            this.longTermPricingStatus = longTermPricingStatus;
        }

        @Override
        public final Builder longTermPricingStatus(String longTermPricingStatus) {
            this.longTermPricingStatus = longTermPricingStatus;
            return this;
        }

        public final String getSnowballType() {
            return this.snowballType;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType == null ? null : snowballType.toString());
            return this;
        }

        public final Collection<String> getJobIds() {
            if (this.jobIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobIds;
        }

        public final void setJobIds(Collection<String> jobIds) {
            this.jobIds = LongTermPricingAssociatedJobIdListCopier.copy(jobIds);
        }

        @Override
        public final Builder jobIds(Collection<String> jobIds) {
            this.jobIds = LongTermPricingAssociatedJobIdListCopier.copy(jobIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobIds(String ... jobIds) {
            this.jobIds(Arrays.asList(jobIds));
            return this;
        }

        public LongTermPricingListEntry build() {
            return new LongTermPricingListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LongTermPricingListEntry> {
        public Builder longTermPricingId(String var1);

        public Builder longTermPricingEndDate(Instant var1);

        public Builder longTermPricingStartDate(Instant var1);

        public Builder longTermPricingType(String var1);

        public Builder longTermPricingType(LongTermPricingType var1);

        public Builder currentActiveJob(String var1);

        public Builder replacementJob(String var1);

        public Builder isLongTermPricingAutoRenew(Boolean var1);

        public Builder longTermPricingStatus(String var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder jobIds(Collection<String> var1);

        public Builder jobIds(String ... var1);
    }
}

