/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.snowball.SnowballClient;
import software.amazon.awssdk.services.snowball.internal.UserAgentUtils;
import software.amazon.awssdk.services.snowball.model.JobListEntry;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse;

public class ListClusterJobsIterable
implements SdkIterable<ListClusterJobsResponse> {
    private final SnowballClient client;
    private final ListClusterJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClusterJobsIterable(SnowballClient client, ListClusterJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClusterJobsResponseFetcher();
    }

    public Iterator<ListClusterJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobListEntry> jobListEntries() {
        Function<ListClusterJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobListEntries() != null) {
                return response.jobListEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClusterJobsResponseFetcher
    implements SyncPageFetcher<ListClusterJobsResponse> {
        private ListClusterJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClusterJobsResponse nextPage(ListClusterJobsResponse previousPage) {
            if (previousPage == null) {
                return ListClusterJobsIterable.this.client.listClusterJobs(ListClusterJobsIterable.this.firstRequest);
            }
            return ListClusterJobsIterable.this.client.listClusterJobs((ListClusterJobsRequest)((Object)ListClusterJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

