/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceName {
    KUBERNETES("KUBERNETES"),
    EKS_ANYWHERE("EKS_ANYWHERE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceName> VALUE_MAP;
    private final String value;

    private ServiceName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceName> knownValues() {
        EnumSet<ServiceName> knownValues = EnumSet.allOf(ServiceName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceName.class, ServiceName::toString);
    }
}

