/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.snowball.SnowballAsyncClient;
import software.amazon.awssdk.services.snowball.internal.UserAgentUtils;
import software.amazon.awssdk.services.snowball.model.ListLongTermPricingRequest;
import software.amazon.awssdk.services.snowball.model.ListLongTermPricingResponse;
import software.amazon.awssdk.services.snowball.model.LongTermPricingListEntry;

public class ListLongTermPricingPublisher
implements SdkPublisher<ListLongTermPricingResponse> {
    private final SnowballAsyncClient client;
    private final ListLongTermPricingRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLongTermPricingPublisher(SnowballAsyncClient client, ListLongTermPricingRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLongTermPricingPublisher(SnowballAsyncClient client, ListLongTermPricingRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLongTermPricingResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLongTermPricingResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LongTermPricingListEntry> longTermPricingEntries() {
        Function<ListLongTermPricingResponse, Iterator> getIterator = response -> {
            if (response != null && response.longTermPricingEntries() != null) {
                return response.longTermPricingEntries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLongTermPricingResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLongTermPricingResponseFetcher
    implements AsyncPageFetcher<ListLongTermPricingResponse> {
        private ListLongTermPricingResponseFetcher() {
        }

        public boolean hasNextPage(ListLongTermPricingResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLongTermPricingResponse> nextPage(ListLongTermPricingResponse previousPage) {
            if (previousPage == null) {
                return ListLongTermPricingPublisher.this.client.listLongTermPricing(ListLongTermPricingPublisher.this.firstRequest);
            }
            return ListLongTermPricingPublisher.this.client.listLongTermPricing((ListLongTermPricingRequest)((Object)ListLongTermPricingPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

