/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SnowballCapacity {
    T50("T50"),
    T80("T80"),
    T100("T100"),
    T42("T42"),
    T98("T98"),
    T8("T8"),
    T14("T14"),
    T32("T32"),
    NO_PREFERENCE("NoPreference"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SnowballCapacity> VALUE_MAP;
    private final String value;

    private SnowballCapacity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SnowballCapacity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SnowballCapacity> knownValues() {
        EnumSet<SnowballCapacity> knownValues = EnumSet.allOf(SnowballCapacity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SnowballCapacity.class, SnowballCapacity::toString);
    }
}

