/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.snowball.model.StorageUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NFSOnDeviceServiceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NFSOnDeviceServiceConfiguration> {
    private static final SdkField<Integer> STORAGE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageLimit").getter(NFSOnDeviceServiceConfiguration.getter(NFSOnDeviceServiceConfiguration::storageLimit)).setter(NFSOnDeviceServiceConfiguration.setter(Builder::storageLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLimit").build()}).build();
    private static final SdkField<String> STORAGE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageUnit").getter(NFSOnDeviceServiceConfiguration.getter(NFSOnDeviceServiceConfiguration::storageUnitAsString)).setter(NFSOnDeviceServiceConfiguration.setter(Builder::storageUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageUnit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_LIMIT_FIELD, STORAGE_UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer storageLimit;
    private final String storageUnit;

    private NFSOnDeviceServiceConfiguration(BuilderImpl builder) {
        this.storageLimit = builder.storageLimit;
        this.storageUnit = builder.storageUnit;
    }

    public final Integer storageLimit() {
        return this.storageLimit;
    }

    public final StorageUnit storageUnit() {
        return StorageUnit.fromValue(this.storageUnit);
    }

    public final String storageUnitAsString() {
        return this.storageUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageUnitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NFSOnDeviceServiceConfiguration)) {
            return false;
        }
        NFSOnDeviceServiceConfiguration other = (NFSOnDeviceServiceConfiguration)obj;
        return Objects.equals(this.storageLimit(), other.storageLimit()) && Objects.equals(this.storageUnitAsString(), other.storageUnitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NFSOnDeviceServiceConfiguration").add("StorageLimit", (Object)this.storageLimit()).add("StorageUnit", (Object)this.storageUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageLimit": {
                return Optional.ofNullable(clazz.cast(this.storageLimit()));
            }
            case "StorageUnit": {
                return Optional.ofNullable(clazz.cast(this.storageUnitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NFSOnDeviceServiceConfiguration, T> g) {
        return obj -> g.apply((NFSOnDeviceServiceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer storageLimit;
        private String storageUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(NFSOnDeviceServiceConfiguration model) {
            this.storageLimit(model.storageLimit);
            this.storageUnit(model.storageUnit);
        }

        public final Integer getStorageLimit() {
            return this.storageLimit;
        }

        public final void setStorageLimit(Integer storageLimit) {
            this.storageLimit = storageLimit;
        }

        @Override
        public final Builder storageLimit(Integer storageLimit) {
            this.storageLimit = storageLimit;
            return this;
        }

        public final String getStorageUnit() {
            return this.storageUnit;
        }

        public final void setStorageUnit(String storageUnit) {
            this.storageUnit = storageUnit;
        }

        @Override
        public final Builder storageUnit(String storageUnit) {
            this.storageUnit = storageUnit;
            return this;
        }

        @Override
        public final Builder storageUnit(StorageUnit storageUnit) {
            this.storageUnit(storageUnit == null ? null : storageUnit.toString());
            return this;
        }

        public NFSOnDeviceServiceConfiguration build() {
            return new NFSOnDeviceServiceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NFSOnDeviceServiceConfiguration> {
        public Builder storageLimit(Integer var1);

        public Builder storageUnit(String var1);

        public Builder storageUnit(StorageUnit var1);
    }
}

