/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.JobState;
import software.amazon.awssdk.services.snowball.model.JobStateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Notification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Notification> {
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Notification.getter(Notification::snsTopicARN)).setter(Notification.setter(Builder::snsTopicARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicARN").build()}).build();
    private static final SdkField<List<String>> JOB_STATES_TO_NOTIFY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Notification.getter(Notification::jobStatesToNotifyAsStrings)).setter(Notification.setter(Builder::jobStatesToNotifyWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatesToNotify").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NOTIFY_ALL_JOB_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Notification.getter(Notification::notifyAllJobStates)).setter(Notification.setter(Builder::notifyAllJobStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotifyAll").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_TOPIC_ARN_FIELD, JOB_STATES_TO_NOTIFY_FIELD, NOTIFY_ALL_JOB_STATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String snsTopicARN;
    private final List<String> jobStatesToNotify;
    private final Boolean notifyAllJobStates;

    private Notification(BuilderImpl builder) {
        this.snsTopicARN = builder.snsTopicARN;
        this.jobStatesToNotify = builder.jobStatesToNotify;
        this.notifyAllJobStates = builder.notifyAllJobStates;
    }

    public String snsTopicARN() {
        return this.snsTopicARN;
    }

    public List<JobState> jobStatesToNotify() {
        return JobStateListCopier.copyStringToEnum(this.jobStatesToNotify);
    }

    public boolean hasJobStatesToNotify() {
        return this.jobStatesToNotify != null && !(this.jobStatesToNotify instanceof SdkAutoConstructList);
    }

    public List<String> jobStatesToNotifyAsStrings() {
        return this.jobStatesToNotify;
    }

    public Boolean notifyAllJobStates() {
        return this.notifyAllJobStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatesToNotifyAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.notifyAllJobStates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)obj;
        return Objects.equals(this.snsTopicARN(), other.snsTopicARN()) && Objects.equals(this.jobStatesToNotifyAsStrings(), other.jobStatesToNotifyAsStrings()) && Objects.equals(this.notifyAllJobStates(), other.notifyAllJobStates());
    }

    public String toString() {
        return ToString.builder((String)"Notification").add("SnsTopicARN", (Object)this.snsTopicARN()).add("JobStatesToNotify", this.jobStatesToNotifyAsStrings()).add("NotifyAllJobStates", (Object)this.notifyAllJobStates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnsTopicARN": {
                return Optional.ofNullable(clazz.cast(this.snsTopicARN()));
            }
            case "JobStatesToNotify": {
                return Optional.ofNullable(clazz.cast(this.jobStatesToNotifyAsStrings()));
            }
            case "NotifyAllJobStates": {
                return Optional.ofNullable(clazz.cast(this.notifyAllJobStates()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Notification, T> g) {
        return obj -> g.apply((Notification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snsTopicARN;
        private List<String> jobStatesToNotify = DefaultSdkAutoConstructList.getInstance();
        private Boolean notifyAllJobStates;

        private BuilderImpl() {
        }

        private BuilderImpl(Notification model) {
            this.snsTopicARN(model.snsTopicARN);
            this.jobStatesToNotifyWithStrings(model.jobStatesToNotify);
            this.notifyAllJobStates(model.notifyAllJobStates);
        }

        public final String getSnsTopicARN() {
            return this.snsTopicARN;
        }

        @Override
        public final Builder snsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
            return this;
        }

        public final void setSnsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
        }

        public final Collection<String> getJobStatesToNotifyAsStrings() {
            return this.jobStatesToNotify;
        }

        @Override
        public final Builder jobStatesToNotifyWithStrings(Collection<String> jobStatesToNotify) {
            this.jobStatesToNotify = JobStateListCopier.copy(jobStatesToNotify);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobStatesToNotifyWithStrings(String ... jobStatesToNotify) {
            this.jobStatesToNotifyWithStrings(Arrays.asList(jobStatesToNotify));
            return this;
        }

        @Override
        public final Builder jobStatesToNotify(Collection<JobState> jobStatesToNotify) {
            this.jobStatesToNotify = JobStateListCopier.copyEnumToString(jobStatesToNotify);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobStatesToNotify(JobState ... jobStatesToNotify) {
            this.jobStatesToNotify(Arrays.asList(jobStatesToNotify));
            return this;
        }

        public final void setJobStatesToNotifyWithStrings(Collection<String> jobStatesToNotify) {
            this.jobStatesToNotify = JobStateListCopier.copy(jobStatesToNotify);
        }

        public final Boolean getNotifyAllJobStates() {
            return this.notifyAllJobStates;
        }

        @Override
        public final Builder notifyAllJobStates(Boolean notifyAllJobStates) {
            this.notifyAllJobStates = notifyAllJobStates;
            return this;
        }

        public final void setNotifyAllJobStates(Boolean notifyAllJobStates) {
            this.notifyAllJobStates = notifyAllJobStates;
        }

        public Notification build() {
            return new Notification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Notification> {
        public Builder snsTopicARN(String var1);

        public Builder jobStatesToNotifyWithStrings(Collection<String> var1);

        public Builder jobStatesToNotifyWithStrings(String ... var1);

        public Builder jobStatesToNotify(Collection<JobState> var1);

        public Builder jobStatesToNotify(JobState ... var1);

        public Builder notifyAllJobStates(Boolean var1);
    }
}

