/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.Notification;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NotificationMarshaller {
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnsTopicARN").isBinary(false).build();
    private static final MarshallingInfo<List> JOBSTATESTONOTIFY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobStatesToNotify").isBinary(false).build();
    private static final MarshallingInfo<Boolean> NOTIFYALLJOBSTATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotifyAll").isBinary(false).build();
    private static final NotificationMarshaller INSTANCE = new NotificationMarshaller();

    private NotificationMarshaller() {
    }

    public static NotificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Notification notification, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)notification, (String)"notification");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)notification.snsTopicARN(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall(notification.jobStatesToNotifyStrings(), JOBSTATESTONOTIFY_BINDING);
            protocolMarshaller.marshall((Object)notification.notifyAllJobStates(), NOTIFYALLJOBSTATES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

