/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.EventTriggerDefinition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventTriggerDefinitionMarshaller {
    private static final MarshallingInfo<String> EVENTRESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventResourceARN").isBinary(false).build();
    private static final EventTriggerDefinitionMarshaller INSTANCE = new EventTriggerDefinitionMarshaller();

    private EventTriggerDefinitionMarshaller() {
    }

    public static EventTriggerDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventTriggerDefinition eventTriggerDefinition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventTriggerDefinition, (String)"eventTriggerDefinition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)eventTriggerDefinition.eventResourceARN(), EVENTRESOURCEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

