/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.ClusterMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ClusterMetadataMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyARN").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MarshallingInfo<String> CLUSTERSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterState").isBinary(false).build();
    private static final MarshallingInfo<String> JOBTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobType").isBinary(false).build();
    private static final MarshallingInfo<String> SNOWBALLTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnowballType").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").isBinary(false).build();
    private static final MarshallingInfo<String> ADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressId").isBinary(false).build();
    private static final MarshallingInfo<String> SHIPPINGOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShippingOption").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Notification").isBinary(false).build();
    private static final MarshallingInfo<String> FORWARDINGADDRESSID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForwardingAddressId").isBinary(false).build();
    private static final ClusterMetadataMarshaller INSTANCE = new ClusterMetadataMarshaller();

    private ClusterMetadataMarshaller() {
    }

    public static ClusterMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ClusterMetadata clusterMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)clusterMetadata, (String)"clusterMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)clusterMetadata.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.kmsKeyARN(), KMSKEYARN_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.clusterStateString(), CLUSTERSTATE_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.jobTypeString(), JOBTYPE_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.snowballTypeString(), SNOWBALLTYPE_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.resources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.addressId(), ADDRESSID_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.shippingOptionString(), SHIPPINGOPTION_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.notification(), NOTIFICATION_BINDING);
            protocolMarshaller.marshall((Object)clusterMetadata.forwardingAddressId(), FORWARDINGADDRESSID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

