/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.ClusterListEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ClusterListEntryMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<String> CLUSTERSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterState").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final ClusterListEntryMarshaller INSTANCE = new ClusterListEntryMarshaller();

    private ClusterListEntryMarshaller() {
    }

    public static ClusterListEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ClusterListEntry clusterListEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)clusterListEntry, (String)"clusterListEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)clusterListEntry.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)clusterListEntry.clusterStateString(), CLUSTERSTATE_BINDING);
            protocolMarshaller.marshall((Object)clusterListEntry.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)clusterListEntry.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

