/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.KeyRange;
import software.amazon.awssdk.services.snowball.transform.S3ResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3Resource
implements StructuredPojo,
ToCopyableBuilder<Builder, S3Resource> {
    private final String bucketArn;
    private final KeyRange keyRange;

    private S3Resource(BuilderImpl builder) {
        this.bucketArn = builder.bucketArn;
        this.keyRange = builder.keyRange;
    }

    public String bucketArn() {
        return this.bucketArn;
    }

    public KeyRange keyRange() {
        return this.keyRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyRange());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Resource)) {
            return false;
        }
        S3Resource other = (S3Resource)obj;
        return Objects.equals(this.bucketArn(), other.bucketArn()) && Objects.equals(this.keyRange(), other.keyRange());
    }

    public String toString() {
        return ToString.builder((String)"S3Resource").add("BucketArn", (Object)this.bucketArn()).add("KeyRange", (Object)this.keyRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketArn": {
                return Optional.of(clazz.cast(this.bucketArn()));
            }
            case "KeyRange": {
                return Optional.of(clazz.cast(this.keyRange()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketArn;
        private KeyRange keyRange;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Resource model) {
            this.bucketArn(model.bucketArn);
            this.keyRange(model.keyRange);
        }

        public final String getBucketArn() {
            return this.bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        public final KeyRange.Builder getKeyRange() {
            return this.keyRange != null ? this.keyRange.toBuilder() : null;
        }

        @Override
        public final Builder keyRange(KeyRange keyRange) {
            this.keyRange = keyRange;
            return this;
        }

        public final void setKeyRange(KeyRange.BuilderImpl keyRange) {
            this.keyRange = keyRange != null ? keyRange.build() : null;
        }

        public S3Resource build() {
            return new S3Resource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3Resource> {
        public Builder bucketArn(String var1);

        public Builder keyRange(KeyRange var1);

        default public Builder keyRange(Consumer<KeyRange.Builder> keyRange) {
            return this.keyRange((KeyRange)((KeyRange.Builder)KeyRange.builder().apply(keyRange)).build());
        }
    }
}

