/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.KeyRangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KeyRange
implements StructuredPojo,
ToCopyableBuilder<Builder, KeyRange> {
    private final String beginMarker;
    private final String endMarker;

    private KeyRange(BuilderImpl builder) {
        this.beginMarker = builder.beginMarker;
        this.endMarker = builder.endMarker;
    }

    public String beginMarker() {
        return this.beginMarker;
    }

    public String endMarker() {
        return this.endMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.beginMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.endMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyRange)) {
            return false;
        }
        KeyRange other = (KeyRange)obj;
        return Objects.equals(this.beginMarker(), other.beginMarker()) && Objects.equals(this.endMarker(), other.endMarker());
    }

    public String toString() {
        return ToString.builder((String)"KeyRange").add("BeginMarker", (Object)this.beginMarker()).add("EndMarker", (Object)this.endMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BeginMarker": {
                return Optional.of(clazz.cast(this.beginMarker()));
            }
            case "EndMarker": {
                return Optional.of(clazz.cast(this.endMarker()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String beginMarker;
        private String endMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyRange model) {
            this.beginMarker(model.beginMarker);
            this.endMarker(model.endMarker);
        }

        public final String getBeginMarker() {
            return this.beginMarker;
        }

        @Override
        public final Builder beginMarker(String beginMarker) {
            this.beginMarker = beginMarker;
            return this;
        }

        public final void setBeginMarker(String beginMarker) {
            this.beginMarker = beginMarker;
        }

        public final String getEndMarker() {
            return this.endMarker;
        }

        @Override
        public final Builder endMarker(String endMarker) {
            this.endMarker = endMarker;
            return this;
        }

        public final void setEndMarker(String endMarker) {
            this.endMarker = endMarker;
        }

        public KeyRange build() {
            return new KeyRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeyRange> {
        public Builder beginMarker(String var1);

        public Builder endMarker(String var1);
    }
}

