/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.snowball.SnowballClient;
import software.amazon.awssdk.services.snowball.model.Address;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse;

public final class DescribeAddressesPaginator
implements SdkIterable<DescribeAddressesResponse> {
    private final SnowballClient client;
    private final DescribeAddressesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeAddressesPaginator(SnowballClient client, DescribeAddressesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAddressesResponseFetcher();
    }

    public Iterator<DescribeAddressesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Address> addresses() {
        Function<DescribeAddressesResponse, Iterator> getIterator = response -> response != null ? response.addresses().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeAddressesResponseFetcher
    implements NextPageFetcher<DescribeAddressesResponse> {
        private DescribeAddressesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAddressesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeAddressesResponse nextPage(DescribeAddressesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAddressesPaginator.this.client.describeAddresses(DescribeAddressesPaginator.this.firstRequest);
            }
            return DescribeAddressesPaginator.this.client.describeAddresses((DescribeAddressesRequest)((Object)DescribeAddressesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

