/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.snowball.model.JobState;
import software.amazon.awssdk.services.snowball.model.JobStateListCopier;
import software.amazon.awssdk.services.snowball.transform.NotificationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Notification
implements StructuredPojo,
ToCopyableBuilder<Builder, Notification> {
    private final String snsTopicARN;
    private final List<String> jobStatesToNotify;
    private final Boolean notifyAllJobStates;

    private Notification(BuilderImpl builder) {
        this.snsTopicARN = builder.snsTopicARN;
        this.jobStatesToNotify = builder.jobStatesToNotify;
        this.notifyAllJobStates = builder.notifyAllJobStates;
    }

    public String snsTopicARN() {
        return this.snsTopicARN;
    }

    public List<JobState> jobStatesToNotify() {
        return TypeConverter.convert(this.jobStatesToNotify, JobState::fromValue);
    }

    public List<String> jobStatesToNotifyStrings() {
        return this.jobStatesToNotify;
    }

    public Boolean notifyAllJobStates() {
        return this.notifyAllJobStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.snsTopicARN() == null ? 0 : this.snsTopicARN().hashCode());
        hashCode = 31 * hashCode + (this.jobStatesToNotifyStrings() == null ? 0 : this.jobStatesToNotifyStrings().hashCode());
        hashCode = 31 * hashCode + (this.notifyAllJobStates() == null ? 0 : this.notifyAllJobStates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)obj;
        if (other.snsTopicARN() == null ^ this.snsTopicARN() == null) {
            return false;
        }
        if (other.snsTopicARN() != null && !other.snsTopicARN().equals(this.snsTopicARN())) {
            return false;
        }
        if (other.jobStatesToNotifyStrings() == null ^ this.jobStatesToNotifyStrings() == null) {
            return false;
        }
        if (other.jobStatesToNotifyStrings() != null && !other.jobStatesToNotifyStrings().equals(this.jobStatesToNotifyStrings())) {
            return false;
        }
        if (other.notifyAllJobStates() == null ^ this.notifyAllJobStates() == null) {
            return false;
        }
        return other.notifyAllJobStates() == null || other.notifyAllJobStates().equals(this.notifyAllJobStates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.snsTopicARN() != null) {
            sb.append("SnsTopicARN: ").append(this.snsTopicARN()).append(",");
        }
        if (this.jobStatesToNotifyStrings() != null) {
            sb.append("JobStatesToNotify: ").append(this.jobStatesToNotifyStrings()).append(",");
        }
        if (this.notifyAllJobStates() != null) {
            sb.append("NotifyAllJobStates: ").append(this.notifyAllJobStates()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnsTopicARN": {
                return Optional.of(clazz.cast(this.snsTopicARN()));
            }
            case "JobStatesToNotify": {
                return Optional.of(clazz.cast(this.jobStatesToNotifyStrings()));
            }
            case "NotifyAllJobStates": {
                return Optional.of(clazz.cast(this.notifyAllJobStates()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String snsTopicARN;
        private List<String> jobStatesToNotify;
        private Boolean notifyAllJobStates;

        private BuilderImpl() {
        }

        private BuilderImpl(Notification model) {
            this.snsTopicARN(model.snsTopicARN);
            this.jobStatesToNotify(model.jobStatesToNotify);
            this.notifyAllJobStates(model.notifyAllJobStates);
        }

        public final String getSnsTopicARN() {
            return this.snsTopicARN;
        }

        @Override
        public final Builder snsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
            return this;
        }

        public final void setSnsTopicARN(String snsTopicARN) {
            this.snsTopicARN = snsTopicARN;
        }

        public final Collection<String> getJobStatesToNotify() {
            return this.jobStatesToNotify;
        }

        @Override
        public final Builder jobStatesToNotify(Collection<String> jobStatesToNotify) {
            this.jobStatesToNotify = JobStateListCopier.copy(jobStatesToNotify);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobStatesToNotify(String ... jobStatesToNotify) {
            this.jobStatesToNotify(Arrays.asList(jobStatesToNotify));
            return this;
        }

        public final void setJobStatesToNotify(Collection<String> jobStatesToNotify) {
            this.jobStatesToNotify = JobStateListCopier.copy(jobStatesToNotify);
        }

        public final Boolean getNotifyAllJobStates() {
            return this.notifyAllJobStates;
        }

        @Override
        public final Builder notifyAllJobStates(Boolean notifyAllJobStates) {
            this.notifyAllJobStates = notifyAllJobStates;
            return this;
        }

        public final void setNotifyAllJobStates(Boolean notifyAllJobStates) {
            this.notifyAllJobStates = notifyAllJobStates;
        }

        public Notification build() {
            return new Notification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Notification> {
        public Builder snsTopicARN(String var1);

        public Builder jobStatesToNotify(Collection<String> var1);

        public Builder jobStatesToNotify(String ... var1);

        public Builder notifyAllJobStates(Boolean var1);
    }
}

