/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.snowball.model.Address;
import software.amazon.awssdk.services.snowball.model.AddressListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAddressesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAddressesResponse> {
    private final List<Address> addresses;
    private final String nextToken;

    private DescribeAddressesResponse(BuilderImpl builder) {
        this.addresses = builder.addresses;
        this.nextToken = builder.nextToken;
    }

    public List<Address> addresses() {
        return this.addresses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.addresses() == null ? 0 : this.addresses().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesResponse)) {
            return false;
        }
        DescribeAddressesResponse other = (DescribeAddressesResponse)((Object)obj);
        if (other.addresses() == null ^ this.addresses() == null) {
            return false;
        }
        if (other.addresses() != null && !other.addresses().equals(this.addresses())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.addresses() != null) {
            sb.append("Addresses: ").append(this.addresses()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Addresses": {
                return Optional.of(clazz.cast(this.addresses()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Address> addresses;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesResponse model) {
            this.addresses(model.addresses);
            this.nextToken(model.nextToken);
        }

        public final Collection<Address.Builder> getAddresses() {
            return this.addresses != null ? (Collection)this.addresses.stream().map(Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addresses(Collection<Address> addresses) {
            this.addresses = AddressListCopier.copy(addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addresses(Address ... addresses) {
            this.addresses(Arrays.asList(addresses));
            return this;
        }

        public final void setAddresses(Collection<Address.BuilderImpl> addresses) {
            this.addresses = AddressListCopier.copyFromBuilder(addresses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeAddressesResponse build() {
            return new DescribeAddressesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAddressesResponse> {
        public Builder addresses(Collection<Address> var1);

        public Builder addresses(Address ... var1);

        public Builder nextToken(String var1);
    }
}

