/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.snowball.model.JobResource;
import software.amazon.awssdk.services.snowball.model.JobType;
import software.amazon.awssdk.services.snowball.model.Notification;
import software.amazon.awssdk.services.snowball.model.ShippingOption;
import software.amazon.awssdk.services.snowball.model.SnowballCapacity;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateJobRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateJobRequest> {
    private final String jobType;
    private final JobResource resources;
    private final String description;
    private final String addressId;
    private final String kmsKeyARN;
    private final String roleARN;
    private final String snowballCapacityPreference;
    private final String shippingOption;
    private final Notification notification;
    private final String clusterId;
    private final String snowballType;
    private final String forwardingAddressId;

    private CreateJobRequest(BuilderImpl builder) {
        this.jobType = builder.jobType;
        this.resources = builder.resources;
        this.description = builder.description;
        this.addressId = builder.addressId;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.clusterId = builder.clusterId;
        this.snowballType = builder.snowballType;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    public JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public String jobTypeString() {
        return this.jobType;
    }

    public JobResource resources() {
        return this.resources;
    }

    public String description() {
        return this.description;
    }

    public String addressId() {
        return this.addressId;
    }

    public String kmsKeyARN() {
        return this.kmsKeyARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public SnowballCapacity snowballCapacityPreference() {
        return SnowballCapacity.fromValue(this.snowballCapacityPreference);
    }

    public String snowballCapacityPreferenceString() {
        return this.snowballCapacityPreference;
    }

    public ShippingOption shippingOption() {
        return ShippingOption.fromValue(this.shippingOption);
    }

    public String shippingOptionString() {
        return this.shippingOption;
    }

    public Notification notification() {
        return this.notification;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public SnowballType snowballType() {
        return SnowballType.fromValue(this.snowballType);
    }

    public String snowballTypeString() {
        return this.snowballType;
    }

    public String forwardingAddressId() {
        return this.forwardingAddressId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobTypeString() == null ? 0 : this.jobTypeString().hashCode());
        hashCode = 31 * hashCode + (this.resources() == null ? 0 : this.resources().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.addressId() == null ? 0 : this.addressId().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyARN() == null ? 0 : this.kmsKeyARN().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.snowballCapacityPreferenceString() == null ? 0 : this.snowballCapacityPreferenceString().hashCode());
        hashCode = 31 * hashCode + (this.shippingOptionString() == null ? 0 : this.shippingOptionString().hashCode());
        hashCode = 31 * hashCode + (this.notification() == null ? 0 : this.notification().hashCode());
        hashCode = 31 * hashCode + (this.clusterId() == null ? 0 : this.clusterId().hashCode());
        hashCode = 31 * hashCode + (this.snowballTypeString() == null ? 0 : this.snowballTypeString().hashCode());
        hashCode = 31 * hashCode + (this.forwardingAddressId() == null ? 0 : this.forwardingAddressId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest)((Object)obj);
        if (other.jobTypeString() == null ^ this.jobTypeString() == null) {
            return false;
        }
        if (other.jobTypeString() != null && !other.jobTypeString().equals(this.jobTypeString())) {
            return false;
        }
        if (other.resources() == null ^ this.resources() == null) {
            return false;
        }
        if (other.resources() != null && !other.resources().equals(this.resources())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.addressId() == null ^ this.addressId() == null) {
            return false;
        }
        if (other.addressId() != null && !other.addressId().equals(this.addressId())) {
            return false;
        }
        if (other.kmsKeyARN() == null ^ this.kmsKeyARN() == null) {
            return false;
        }
        if (other.kmsKeyARN() != null && !other.kmsKeyARN().equals(this.kmsKeyARN())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.snowballCapacityPreferenceString() == null ^ this.snowballCapacityPreferenceString() == null) {
            return false;
        }
        if (other.snowballCapacityPreferenceString() != null && !other.snowballCapacityPreferenceString().equals(this.snowballCapacityPreferenceString())) {
            return false;
        }
        if (other.shippingOptionString() == null ^ this.shippingOptionString() == null) {
            return false;
        }
        if (other.shippingOptionString() != null && !other.shippingOptionString().equals(this.shippingOptionString())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.clusterId() == null ^ this.clusterId() == null) {
            return false;
        }
        if (other.clusterId() != null && !other.clusterId().equals(this.clusterId())) {
            return false;
        }
        if (other.snowballTypeString() == null ^ this.snowballTypeString() == null) {
            return false;
        }
        if (other.snowballTypeString() != null && !other.snowballTypeString().equals(this.snowballTypeString())) {
            return false;
        }
        if (other.forwardingAddressId() == null ^ this.forwardingAddressId() == null) {
            return false;
        }
        return other.forwardingAddressId() == null || other.forwardingAddressId().equals(this.forwardingAddressId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobTypeString() != null) {
            sb.append("JobType: ").append(this.jobTypeString()).append(",");
        }
        if (this.resources() != null) {
            sb.append("Resources: ").append(this.resources()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.addressId() != null) {
            sb.append("AddressId: ").append(this.addressId()).append(",");
        }
        if (this.kmsKeyARN() != null) {
            sb.append("KmsKeyARN: ").append(this.kmsKeyARN()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.snowballCapacityPreferenceString() != null) {
            sb.append("SnowballCapacityPreference: ").append(this.snowballCapacityPreferenceString()).append(",");
        }
        if (this.shippingOptionString() != null) {
            sb.append("ShippingOption: ").append(this.shippingOptionString()).append(",");
        }
        if (this.notification() != null) {
            sb.append("Notification: ").append(this.notification()).append(",");
        }
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.snowballTypeString() != null) {
            sb.append("SnowballType: ").append(this.snowballTypeString()).append(",");
        }
        if (this.forwardingAddressId() != null) {
            sb.append("ForwardingAddressId: ").append(this.forwardingAddressId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobType": {
                return Optional.of(clazz.cast(this.jobTypeString()));
            }
            case "Resources": {
                return Optional.of(clazz.cast(this.resources()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "AddressId": {
                return Optional.of(clazz.cast(this.addressId()));
            }
            case "KmsKeyARN": {
                return Optional.of(clazz.cast(this.kmsKeyARN()));
            }
            case "RoleARN": {
                return Optional.of(clazz.cast(this.roleARN()));
            }
            case "SnowballCapacityPreference": {
                return Optional.of(clazz.cast(this.snowballCapacityPreferenceString()));
            }
            case "ShippingOption": {
                return Optional.of(clazz.cast(this.shippingOptionString()));
            }
            case "Notification": {
                return Optional.of(clazz.cast(this.notification()));
            }
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "SnowballType": {
                return Optional.of(clazz.cast(this.snowballTypeString()));
            }
            case "ForwardingAddressId": {
                return Optional.of(clazz.cast(this.forwardingAddressId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String jobType;
        private JobResource resources;
        private String description;
        private String addressId;
        private String kmsKeyARN;
        private String roleARN;
        private String snowballCapacityPreference;
        private String shippingOption;
        private Notification notification;
        private String clusterId;
        private String snowballType;
        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            this.jobType(model.jobType);
            this.resources(model.resources);
            this.description(model.description);
            this.addressId(model.addressId);
            this.kmsKeyARN(model.kmsKeyARN);
            this.roleARN(model.roleARN);
            this.snowballCapacityPreference(model.snowballCapacityPreference);
            this.shippingOption(model.shippingOption);
            this.notification(model.notification);
            this.clusterId(model.clusterId);
            this.snowballType(model.snowballType);
            this.forwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobType() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final JobResource.Builder getResources() {
            return this.resources != null ? this.resources.toBuilder() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAddressId() {
            return this.addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getKmsKeyARN() {
            return this.kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getSnowballCapacityPreference() {
            return this.snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference.toString());
            return this;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        public final String getShippingOption() {
            return this.shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getSnowballType() {
            return this.snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final String getForwardingAddressId() {
            return this.forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateJobRequest> {
        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder resources(JobResource var1);

        public Builder description(String var1);

        public Builder addressId(String var1);

        public Builder kmsKeyARN(String var1);

        public Builder roleARN(String var1);

        public Builder snowballCapacityPreference(String var1);

        public Builder snowballCapacityPreference(SnowballCapacity var1);

        public Builder shippingOption(String var1);

        public Builder shippingOption(ShippingOption var1);

        public Builder notification(Notification var1);

        public Builder clusterId(String var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder forwardingAddressId(String var1);
    }
}

