/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.LambdaResource;

@SdkInternalApi
public class LambdaResourceMarshaller {
    private static final MarshallingInfo<String> LAMBDAARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LambdaArn").build();
    private static final MarshallingInfo<List> EVENTTRIGGERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventTriggers").build();
    private static final LambdaResourceMarshaller INSTANCE = new LambdaResourceMarshaller();

    public static LambdaResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LambdaResource lambdaResource, ProtocolMarshaller protocolMarshaller) {
        if (lambdaResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)lambdaResource.lambdaArn(), LAMBDAARN_BINDING);
            protocolMarshaller.marshall(lambdaResource.eventTriggers(), EVENTTRIGGERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

