/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.transform.JobLogsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobLogs
implements StructuredPojo,
ToCopyableBuilder<Builder, JobLogs> {
    private final String jobCompletionReportURI;
    private final String jobSuccessLogURI;
    private final String jobFailureLogURI;

    private JobLogs(BuilderImpl builder) {
        this.jobCompletionReportURI = builder.jobCompletionReportURI;
        this.jobSuccessLogURI = builder.jobSuccessLogURI;
        this.jobFailureLogURI = builder.jobFailureLogURI;
    }

    public String jobCompletionReportURI() {
        return this.jobCompletionReportURI;
    }

    public String jobSuccessLogURI() {
        return this.jobSuccessLogURI;
    }

    public String jobFailureLogURI() {
        return this.jobFailureLogURI;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobCompletionReportURI() == null ? 0 : this.jobCompletionReportURI().hashCode());
        hashCode = 31 * hashCode + (this.jobSuccessLogURI() == null ? 0 : this.jobSuccessLogURI().hashCode());
        hashCode = 31 * hashCode + (this.jobFailureLogURI() == null ? 0 : this.jobFailureLogURI().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobLogs)) {
            return false;
        }
        JobLogs other = (JobLogs)obj;
        if (other.jobCompletionReportURI() == null ^ this.jobCompletionReportURI() == null) {
            return false;
        }
        if (other.jobCompletionReportURI() != null && !other.jobCompletionReportURI().equals(this.jobCompletionReportURI())) {
            return false;
        }
        if (other.jobSuccessLogURI() == null ^ this.jobSuccessLogURI() == null) {
            return false;
        }
        if (other.jobSuccessLogURI() != null && !other.jobSuccessLogURI().equals(this.jobSuccessLogURI())) {
            return false;
        }
        if (other.jobFailureLogURI() == null ^ this.jobFailureLogURI() == null) {
            return false;
        }
        return other.jobFailureLogURI() == null || other.jobFailureLogURI().equals(this.jobFailureLogURI());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobCompletionReportURI() != null) {
            sb.append("JobCompletionReportURI: ").append(this.jobCompletionReportURI()).append(",");
        }
        if (this.jobSuccessLogURI() != null) {
            sb.append("JobSuccessLogURI: ").append(this.jobSuccessLogURI()).append(",");
        }
        if (this.jobFailureLogURI() != null) {
            sb.append("JobFailureLogURI: ").append(this.jobFailureLogURI()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobLogsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobCompletionReportURI;
        private String jobSuccessLogURI;
        private String jobFailureLogURI;

        private BuilderImpl() {
        }

        private BuilderImpl(JobLogs model) {
            this.setJobCompletionReportURI(model.jobCompletionReportURI);
            this.setJobSuccessLogURI(model.jobSuccessLogURI);
            this.setJobFailureLogURI(model.jobFailureLogURI);
        }

        public final String getJobCompletionReportURI() {
            return this.jobCompletionReportURI;
        }

        @Override
        public final Builder jobCompletionReportURI(String jobCompletionReportURI) {
            this.jobCompletionReportURI = jobCompletionReportURI;
            return this;
        }

        public final void setJobCompletionReportURI(String jobCompletionReportURI) {
            this.jobCompletionReportURI = jobCompletionReportURI;
        }

        public final String getJobSuccessLogURI() {
            return this.jobSuccessLogURI;
        }

        @Override
        public final Builder jobSuccessLogURI(String jobSuccessLogURI) {
            this.jobSuccessLogURI = jobSuccessLogURI;
            return this;
        }

        public final void setJobSuccessLogURI(String jobSuccessLogURI) {
            this.jobSuccessLogURI = jobSuccessLogURI;
        }

        public final String getJobFailureLogURI() {
            return this.jobFailureLogURI;
        }

        @Override
        public final Builder jobFailureLogURI(String jobFailureLogURI) {
            this.jobFailureLogURI = jobFailureLogURI;
            return this;
        }

        public final void setJobFailureLogURI(String jobFailureLogURI) {
            this.jobFailureLogURI = jobFailureLogURI;
        }

        public JobLogs build() {
            return new JobLogs(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobLogs> {
        public Builder jobCompletionReportURI(String var1);

        public Builder jobSuccessLogURI(String var1);

        public Builder jobFailureLogURI(String var1);
    }
}

