/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.snowball.model.JobResource;
import software.amazon.awssdk.services.snowball.model.JobType;
import software.amazon.awssdk.services.snowball.model.Notification;
import software.amazon.awssdk.services.snowball.model.ShippingOption;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateClusterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private final String jobType;
    private final JobResource resources;
    private final String description;
    private final String addressId;
    private final String kmsKeyARN;
    private final String roleARN;
    private final String snowballType;
    private final String shippingOption;
    private final Notification notification;
    private final String forwardingAddressId;

    private CreateClusterRequest(BuilderImpl builder) {
        this.jobType = builder.jobType;
        this.resources = builder.resources;
        this.description = builder.description;
        this.addressId = builder.addressId;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.snowballType = builder.snowballType;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    public String jobType() {
        return this.jobType;
    }

    public JobResource resources() {
        return this.resources;
    }

    public String description() {
        return this.description;
    }

    public String addressId() {
        return this.addressId;
    }

    public String kmsKeyARN() {
        return this.kmsKeyARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String snowballType() {
        return this.snowballType;
    }

    public String shippingOption() {
        return this.shippingOption;
    }

    public Notification notification() {
        return this.notification;
    }

    public String forwardingAddressId() {
        return this.forwardingAddressId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobType() == null ? 0 : this.jobType().hashCode());
        hashCode = 31 * hashCode + (this.resources() == null ? 0 : this.resources().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.addressId() == null ? 0 : this.addressId().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyARN() == null ? 0 : this.kmsKeyARN().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.snowballType() == null ? 0 : this.snowballType().hashCode());
        hashCode = 31 * hashCode + (this.shippingOption() == null ? 0 : this.shippingOption().hashCode());
        hashCode = 31 * hashCode + (this.notification() == null ? 0 : this.notification().hashCode());
        hashCode = 31 * hashCode + (this.forwardingAddressId() == null ? 0 : this.forwardingAddressId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        if (other.jobType() == null ^ this.jobType() == null) {
            return false;
        }
        if (other.jobType() != null && !other.jobType().equals(this.jobType())) {
            return false;
        }
        if (other.resources() == null ^ this.resources() == null) {
            return false;
        }
        if (other.resources() != null && !other.resources().equals(this.resources())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.addressId() == null ^ this.addressId() == null) {
            return false;
        }
        if (other.addressId() != null && !other.addressId().equals(this.addressId())) {
            return false;
        }
        if (other.kmsKeyARN() == null ^ this.kmsKeyARN() == null) {
            return false;
        }
        if (other.kmsKeyARN() != null && !other.kmsKeyARN().equals(this.kmsKeyARN())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.snowballType() == null ^ this.snowballType() == null) {
            return false;
        }
        if (other.snowballType() != null && !other.snowballType().equals(this.snowballType())) {
            return false;
        }
        if (other.shippingOption() == null ^ this.shippingOption() == null) {
            return false;
        }
        if (other.shippingOption() != null && !other.shippingOption().equals(this.shippingOption())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.forwardingAddressId() == null ^ this.forwardingAddressId() == null) {
            return false;
        }
        return other.forwardingAddressId() == null || other.forwardingAddressId().equals(this.forwardingAddressId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobType() != null) {
            sb.append("JobType: ").append(this.jobType()).append(",");
        }
        if (this.resources() != null) {
            sb.append("Resources: ").append(this.resources()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.addressId() != null) {
            sb.append("AddressId: ").append(this.addressId()).append(",");
        }
        if (this.kmsKeyARN() != null) {
            sb.append("KmsKeyARN: ").append(this.kmsKeyARN()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.snowballType() != null) {
            sb.append("SnowballType: ").append(this.snowballType()).append(",");
        }
        if (this.shippingOption() != null) {
            sb.append("ShippingOption: ").append(this.shippingOption()).append(",");
        }
        if (this.notification() != null) {
            sb.append("Notification: ").append(this.notification()).append(",");
        }
        if (this.forwardingAddressId() != null) {
            sb.append("ForwardingAddressId: ").append(this.forwardingAddressId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobType;
        private JobResource resources;
        private String description;
        private String addressId;
        private String kmsKeyARN;
        private String roleARN;
        private String snowballType;
        private String shippingOption;
        private Notification notification;
        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            this.setJobType(model.jobType);
            this.setResources(model.resources);
            this.setDescription(model.description);
            this.setAddressId(model.addressId);
            this.setKmsKeyARN(model.kmsKeyARN);
            this.setRoleARN(model.roleARN);
            this.setSnowballType(model.snowballType);
            this.setShippingOption(model.shippingOption);
            this.setNotification(model.notification);
            this.setForwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobType() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final JobResource getResources() {
            return this.resources;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource resources) {
            this.resources = resources;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAddressId() {
            return this.addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final String getKmsKeyARN() {
            return this.kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getSnowballType() {
            return this.snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final String getShippingOption() {
            return this.shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption.toString());
            return this;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        public final Notification getNotification() {
            return this.notification;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification notification) {
            this.notification = notification;
        }

        public final String getForwardingAddressId() {
            return this.forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder resources(JobResource var1);

        public Builder description(String var1);

        public Builder addressId(String var1);

        public Builder kmsKeyARN(String var1);

        public Builder roleARN(String var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder shippingOption(String var1);

        public Builder shippingOption(ShippingOption var1);

        public Builder notification(Notification var1);

        public Builder forwardingAddressId(String var1);
    }
}

