/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.snowball.model.Notification;

@SdkInternalApi
public class NotificationMarshaller {
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnsTopicARN").build();
    private static final MarshallingInfo<List> JOBSTATESTONOTIFY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobStatesToNotify").build();
    private static final MarshallingInfo<Boolean> NOTIFYALLJOBSTATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotifyAll").build();
    private static final NotificationMarshaller instance = new NotificationMarshaller();

    public static NotificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(Notification notification, ProtocolMarshaller protocolMarshaller) {
        if (notification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)notification.snsTopicARN(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall(notification.jobStatesToNotify(), JOBSTATESTONOTIFY_BINDING);
            protocolMarshaller.marshall((Object)notification.notifyAllJobStates(), NOTIFYALLJOBSTATES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

