/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.snowball.model.JobMetadata;
import software.amazon.awssdk.services.snowball.transform.DataTransferUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.JobLogsUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.JobResourceUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.NotificationUnmarshaller;
import software.amazon.awssdk.services.snowball.transform.ShippingDetailsUnmarshaller;

public class JobMetadataUnmarshaller
implements Unmarshaller<JobMetadata, JsonUnmarshallerContext> {
    private static JobMetadataUnmarshaller INSTANCE;

    public JobMetadata unmarshall(JsonUnmarshallerContext context) throws Exception {
        JobMetadata.Builder jobMetadataBuilder = JobMetadata.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("JobId", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.jobId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("JobState", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.jobState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("JobType", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.jobType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SnowballType", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.snowballType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.creationDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Resources", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.resources(JobResourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("KmsKeyARN", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.kmsKeyARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RoleARN", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.roleARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AddressId", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.addressId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ShippingDetails", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.shippingDetails(ShippingDetailsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SnowballCapacityPreference", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.snowballCapacityPreference((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Notification", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.notification(NotificationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DataTransferProgress", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.dataTransferProgress(DataTransferUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("JobLogInfo", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.jobLogInfo(JobLogsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ClusterId", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.clusterId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ForwardingAddressId", targetDepth)) {
                    context.nextToken();
                    jobMetadataBuilder.forwardingAddressId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (JobMetadata)jobMetadataBuilder.build();
    }

    public static JobMetadataUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JobMetadataUnmarshaller();
        }
        return INSTANCE;
    }
}

