/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.LambdaResource;
import software.amazon.awssdk.services.snowball.model.LambdaResourceListCopier;
import software.amazon.awssdk.services.snowball.model.S3Resource;
import software.amazon.awssdk.services.snowball.model.S3ResourceListCopier;
import software.amazon.awssdk.services.snowball.transform.JobResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobResource
implements StructuredPojo,
ToCopyableBuilder<Builder, JobResource> {
    private final List<S3Resource> s3Resources;
    private final List<LambdaResource> lambdaResources;

    private JobResource(BuilderImpl builder) {
        this.s3Resources = builder.s3Resources;
        this.lambdaResources = builder.lambdaResources;
    }

    public List<S3Resource> s3Resources() {
        return this.s3Resources;
    }

    public List<LambdaResource> lambdaResources() {
        return this.lambdaResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.s3Resources() == null ? 0 : this.s3Resources().hashCode());
        hashCode = 31 * hashCode + (this.lambdaResources() == null ? 0 : this.lambdaResources().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobResource)) {
            return false;
        }
        JobResource other = (JobResource)obj;
        if (other.s3Resources() == null ^ this.s3Resources() == null) {
            return false;
        }
        if (other.s3Resources() != null && !other.s3Resources().equals(this.s3Resources())) {
            return false;
        }
        if (other.lambdaResources() == null ^ this.lambdaResources() == null) {
            return false;
        }
        return other.lambdaResources() == null || other.lambdaResources().equals(this.lambdaResources());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.s3Resources() != null) {
            sb.append("S3Resources: ").append(this.s3Resources()).append(",");
        }
        if (this.lambdaResources() != null) {
            sb.append("LambdaResources: ").append(this.lambdaResources()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<S3Resource> s3Resources;
        private List<LambdaResource> lambdaResources;

        private BuilderImpl() {
        }

        private BuilderImpl(JobResource model) {
            this.setS3Resources(model.s3Resources);
            this.setLambdaResources(model.lambdaResources);
        }

        public final Collection<S3Resource> getS3Resources() {
            return this.s3Resources;
        }

        @Override
        public final Builder s3Resources(Collection<S3Resource> s3Resources) {
            this.s3Resources = S3ResourceListCopier.copy(s3Resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(S3Resource ... s3Resources) {
            this.s3Resources(Arrays.asList(s3Resources));
            return this;
        }

        public final void setS3Resources(Collection<S3Resource> s3Resources) {
            this.s3Resources = S3ResourceListCopier.copy(s3Resources);
        }

        @SafeVarargs
        public final void setS3Resources(S3Resource ... s3Resources) {
            this.s3Resources(Arrays.asList(s3Resources));
        }

        public final Collection<LambdaResource> getLambdaResources() {
            return this.lambdaResources;
        }

        @Override
        public final Builder lambdaResources(Collection<LambdaResource> lambdaResources) {
            this.lambdaResources = LambdaResourceListCopier.copy(lambdaResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaResources(LambdaResource ... lambdaResources) {
            this.lambdaResources(Arrays.asList(lambdaResources));
            return this;
        }

        public final void setLambdaResources(Collection<LambdaResource> lambdaResources) {
            this.lambdaResources = LambdaResourceListCopier.copy(lambdaResources);
        }

        @SafeVarargs
        public final void setLambdaResources(LambdaResource ... lambdaResources) {
            this.lambdaResources(Arrays.asList(lambdaResources));
        }

        public JobResource build() {
            return new JobResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobResource> {
        public Builder s3Resources(Collection<S3Resource> var1);

        public Builder s3Resources(S3Resource ... var1);

        public Builder lambdaResources(Collection<LambdaResource> var1);

        public Builder lambdaResources(LambdaResource ... var1);
    }
}

