/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.snowball.model.DataTransfer;
import software.amazon.awssdk.services.snowball.model.JobLogs;
import software.amazon.awssdk.services.snowball.model.JobResource;
import software.amazon.awssdk.services.snowball.model.JobState;
import software.amazon.awssdk.services.snowball.model.JobType;
import software.amazon.awssdk.services.snowball.model.Notification;
import software.amazon.awssdk.services.snowball.model.ShippingDetails;
import software.amazon.awssdk.services.snowball.model.SnowballCapacity;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.services.snowball.transform.JobMetadataMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, JobMetadata> {
    private final String jobId;
    private final String jobState;
    private final String jobType;
    private final String snowballType;
    private final Instant creationDate;
    private final JobResource resources;
    private final String description;
    private final String kmsKeyARN;
    private final String roleARN;
    private final String addressId;
    private final ShippingDetails shippingDetails;
    private final String snowballCapacityPreference;
    private final Notification notification;
    private final DataTransfer dataTransferProgress;
    private final JobLogs jobLogInfo;
    private final String clusterId;
    private final String forwardingAddressId;

    private JobMetadata(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobState = builder.jobState;
        this.jobType = builder.jobType;
        this.snowballType = builder.snowballType;
        this.creationDate = builder.creationDate;
        this.resources = builder.resources;
        this.description = builder.description;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.addressId = builder.addressId;
        this.shippingDetails = builder.shippingDetails;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
        this.notification = builder.notification;
        this.dataTransferProgress = builder.dataTransferProgress;
        this.jobLogInfo = builder.jobLogInfo;
        this.clusterId = builder.clusterId;
        this.forwardingAddressId = builder.forwardingAddressId;
    }

    public String jobId() {
        return this.jobId;
    }

    public String jobState() {
        return this.jobState;
    }

    public String jobType() {
        return this.jobType;
    }

    public String snowballType() {
        return this.snowballType;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public JobResource resources() {
        return this.resources;
    }

    public String description() {
        return this.description;
    }

    public String kmsKeyARN() {
        return this.kmsKeyARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String addressId() {
        return this.addressId;
    }

    public ShippingDetails shippingDetails() {
        return this.shippingDetails;
    }

    public String snowballCapacityPreference() {
        return this.snowballCapacityPreference;
    }

    public Notification notification() {
        return this.notification;
    }

    public DataTransfer dataTransferProgress() {
        return this.dataTransferProgress;
    }

    public JobLogs jobLogInfo() {
        return this.jobLogInfo;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String forwardingAddressId() {
        return this.forwardingAddressId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobId() == null ? 0 : this.jobId().hashCode());
        hashCode = 31 * hashCode + (this.jobState() == null ? 0 : this.jobState().hashCode());
        hashCode = 31 * hashCode + (this.jobType() == null ? 0 : this.jobType().hashCode());
        hashCode = 31 * hashCode + (this.snowballType() == null ? 0 : this.snowballType().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.resources() == null ? 0 : this.resources().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyARN() == null ? 0 : this.kmsKeyARN().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.addressId() == null ? 0 : this.addressId().hashCode());
        hashCode = 31 * hashCode + (this.shippingDetails() == null ? 0 : this.shippingDetails().hashCode());
        hashCode = 31 * hashCode + (this.snowballCapacityPreference() == null ? 0 : this.snowballCapacityPreference().hashCode());
        hashCode = 31 * hashCode + (this.notification() == null ? 0 : this.notification().hashCode());
        hashCode = 31 * hashCode + (this.dataTransferProgress() == null ? 0 : this.dataTransferProgress().hashCode());
        hashCode = 31 * hashCode + (this.jobLogInfo() == null ? 0 : this.jobLogInfo().hashCode());
        hashCode = 31 * hashCode + (this.clusterId() == null ? 0 : this.clusterId().hashCode());
        hashCode = 31 * hashCode + (this.forwardingAddressId() == null ? 0 : this.forwardingAddressId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobMetadata)) {
            return false;
        }
        JobMetadata other = (JobMetadata)obj;
        if (other.jobId() == null ^ this.jobId() == null) {
            return false;
        }
        if (other.jobId() != null && !other.jobId().equals(this.jobId())) {
            return false;
        }
        if (other.jobState() == null ^ this.jobState() == null) {
            return false;
        }
        if (other.jobState() != null && !other.jobState().equals(this.jobState())) {
            return false;
        }
        if (other.jobType() == null ^ this.jobType() == null) {
            return false;
        }
        if (other.jobType() != null && !other.jobType().equals(this.jobType())) {
            return false;
        }
        if (other.snowballType() == null ^ this.snowballType() == null) {
            return false;
        }
        if (other.snowballType() != null && !other.snowballType().equals(this.snowballType())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.resources() == null ^ this.resources() == null) {
            return false;
        }
        if (other.resources() != null && !other.resources().equals(this.resources())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.kmsKeyARN() == null ^ this.kmsKeyARN() == null) {
            return false;
        }
        if (other.kmsKeyARN() != null && !other.kmsKeyARN().equals(this.kmsKeyARN())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.addressId() == null ^ this.addressId() == null) {
            return false;
        }
        if (other.addressId() != null && !other.addressId().equals(this.addressId())) {
            return false;
        }
        if (other.shippingDetails() == null ^ this.shippingDetails() == null) {
            return false;
        }
        if (other.shippingDetails() != null && !other.shippingDetails().equals(this.shippingDetails())) {
            return false;
        }
        if (other.snowballCapacityPreference() == null ^ this.snowballCapacityPreference() == null) {
            return false;
        }
        if (other.snowballCapacityPreference() != null && !other.snowballCapacityPreference().equals(this.snowballCapacityPreference())) {
            return false;
        }
        if (other.notification() == null ^ this.notification() == null) {
            return false;
        }
        if (other.notification() != null && !other.notification().equals(this.notification())) {
            return false;
        }
        if (other.dataTransferProgress() == null ^ this.dataTransferProgress() == null) {
            return false;
        }
        if (other.dataTransferProgress() != null && !other.dataTransferProgress().equals(this.dataTransferProgress())) {
            return false;
        }
        if (other.jobLogInfo() == null ^ this.jobLogInfo() == null) {
            return false;
        }
        if (other.jobLogInfo() != null && !other.jobLogInfo().equals(this.jobLogInfo())) {
            return false;
        }
        if (other.clusterId() == null ^ this.clusterId() == null) {
            return false;
        }
        if (other.clusterId() != null && !other.clusterId().equals(this.clusterId())) {
            return false;
        }
        if (other.forwardingAddressId() == null ^ this.forwardingAddressId() == null) {
            return false;
        }
        return other.forwardingAddressId() == null || other.forwardingAddressId().equals(this.forwardingAddressId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobId() != null) {
            sb.append("JobId: ").append(this.jobId()).append(",");
        }
        if (this.jobState() != null) {
            sb.append("JobState: ").append(this.jobState()).append(",");
        }
        if (this.jobType() != null) {
            sb.append("JobType: ").append(this.jobType()).append(",");
        }
        if (this.snowballType() != null) {
            sb.append("SnowballType: ").append(this.snowballType()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.resources() != null) {
            sb.append("Resources: ").append(this.resources()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.kmsKeyARN() != null) {
            sb.append("KmsKeyARN: ").append(this.kmsKeyARN()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.addressId() != null) {
            sb.append("AddressId: ").append(this.addressId()).append(",");
        }
        if (this.shippingDetails() != null) {
            sb.append("ShippingDetails: ").append(this.shippingDetails()).append(",");
        }
        if (this.snowballCapacityPreference() != null) {
            sb.append("SnowballCapacityPreference: ").append(this.snowballCapacityPreference()).append(",");
        }
        if (this.notification() != null) {
            sb.append("Notification: ").append(this.notification()).append(",");
        }
        if (this.dataTransferProgress() != null) {
            sb.append("DataTransferProgress: ").append(this.dataTransferProgress()).append(",");
        }
        if (this.jobLogInfo() != null) {
            sb.append("JobLogInfo: ").append(this.jobLogInfo()).append(",");
        }
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.forwardingAddressId() != null) {
            sb.append("ForwardingAddressId: ").append(this.forwardingAddressId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobState;
        private String jobType;
        private String snowballType;
        private Instant creationDate;
        private JobResource resources;
        private String description;
        private String kmsKeyARN;
        private String roleARN;
        private String addressId;
        private ShippingDetails shippingDetails;
        private String snowballCapacityPreference;
        private Notification notification;
        private DataTransfer dataTransferProgress;
        private JobLogs jobLogInfo;
        private String clusterId;
        private String forwardingAddressId;

        private BuilderImpl() {
        }

        private BuilderImpl(JobMetadata model) {
            this.setJobId(model.jobId);
            this.setJobState(model.jobState);
            this.setJobType(model.jobType);
            this.setSnowballType(model.snowballType);
            this.setCreationDate(model.creationDate);
            this.setResources(model.resources);
            this.setDescription(model.description);
            this.setKmsKeyARN(model.kmsKeyARN);
            this.setRoleARN(model.roleARN);
            this.setAddressId(model.addressId);
            this.setShippingDetails(model.shippingDetails);
            this.setSnowballCapacityPreference(model.snowballCapacityPreference);
            this.setNotification(model.notification);
            this.setDataTransferProgress(model.dataTransferProgress);
            this.setJobLogInfo(model.jobLogInfo);
            this.setClusterId(model.clusterId);
            this.setForwardingAddressId(model.forwardingAddressId);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getJobState() {
            return this.jobState;
        }

        @Override
        public final Builder jobState(String jobState) {
            this.jobState = jobState;
            return this;
        }

        @Override
        public final Builder jobState(JobState jobState) {
            this.jobState(jobState.toString());
            return this;
        }

        public final void setJobState(String jobState) {
            this.jobState = jobState;
        }

        public final void setJobState(JobState jobState) {
            this.jobState(jobState.toString());
        }

        public final String getJobType() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final void setJobType(JobType jobType) {
            this.jobType(jobType.toString());
        }

        public final String getSnowballType() {
            return this.snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
            return this;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        public final void setSnowballType(SnowballType snowballType) {
            this.snowballType(snowballType.toString());
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final JobResource getResources() {
            return this.resources;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final void setResources(JobResource resources) {
            this.resources = resources;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKmsKeyARN() {
            return this.kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getAddressId() {
            return this.addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        public final ShippingDetails getShippingDetails() {
            return this.shippingDetails;
        }

        @Override
        public final Builder shippingDetails(ShippingDetails shippingDetails) {
            this.shippingDetails = shippingDetails;
            return this;
        }

        public final void setShippingDetails(ShippingDetails shippingDetails) {
            this.shippingDetails = shippingDetails;
        }

        public final String getSnowballCapacityPreference() {
            return this.snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference.toString());
            return this;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        public final void setSnowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference.toString());
        }

        public final Notification getNotification() {
            return this.notification;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final void setNotification(Notification notification) {
            this.notification = notification;
        }

        public final DataTransfer getDataTransferProgress() {
            return this.dataTransferProgress;
        }

        @Override
        public final Builder dataTransferProgress(DataTransfer dataTransferProgress) {
            this.dataTransferProgress = dataTransferProgress;
            return this;
        }

        public final void setDataTransferProgress(DataTransfer dataTransferProgress) {
            this.dataTransferProgress = dataTransferProgress;
        }

        public final JobLogs getJobLogInfo() {
            return this.jobLogInfo;
        }

        @Override
        public final Builder jobLogInfo(JobLogs jobLogInfo) {
            this.jobLogInfo = jobLogInfo;
            return this;
        }

        public final void setJobLogInfo(JobLogs jobLogInfo) {
            this.jobLogInfo = jobLogInfo;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getForwardingAddressId() {
            return this.forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        public JobMetadata build() {
            return new JobMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobMetadata> {
        public Builder jobId(String var1);

        public Builder jobState(String var1);

        public Builder jobState(JobState var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder creationDate(Instant var1);

        public Builder resources(JobResource var1);

        public Builder description(String var1);

        public Builder kmsKeyARN(String var1);

        public Builder roleARN(String var1);

        public Builder addressId(String var1);

        public Builder shippingDetails(ShippingDetails var1);

        public Builder snowballCapacityPreference(String var1);

        public Builder snowballCapacityPreference(SnowballCapacity var1);

        public Builder notification(Notification var1);

        public Builder dataTransferProgress(DataTransfer var1);

        public Builder jobLogInfo(JobLogs var1);

        public Builder clusterId(String var1);

        public Builder forwardingAddressId(String var1);
    }
}

