/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.snowball.model.JobMetadata;
import software.amazon.awssdk.services.snowball.model.JobMetadataListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeJobResponse> {
    private final JobMetadata jobMetadata;
    private final List<JobMetadata> subJobMetadata;

    private DescribeJobResponse(BuilderImpl builder) {
        this.jobMetadata = builder.jobMetadata;
        this.subJobMetadata = builder.subJobMetadata;
    }

    public JobMetadata jobMetadata() {
        return this.jobMetadata;
    }

    public List<JobMetadata> subJobMetadata() {
        return this.subJobMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobMetadata() == null ? 0 : this.jobMetadata().hashCode());
        hashCode = 31 * hashCode + (this.subJobMetadata() == null ? 0 : this.subJobMetadata().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobResponse)) {
            return false;
        }
        DescribeJobResponse other = (DescribeJobResponse)((Object)obj);
        if (other.jobMetadata() == null ^ this.jobMetadata() == null) {
            return false;
        }
        if (other.jobMetadata() != null && !other.jobMetadata().equals(this.jobMetadata())) {
            return false;
        }
        if (other.subJobMetadata() == null ^ this.subJobMetadata() == null) {
            return false;
        }
        return other.subJobMetadata() == null || other.subJobMetadata().equals(this.subJobMetadata());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobMetadata() != null) {
            sb.append("JobMetadata: ").append(this.jobMetadata()).append(",");
        }
        if (this.subJobMetadata() != null) {
            sb.append("SubJobMetadata: ").append(this.subJobMetadata()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private JobMetadata jobMetadata;
        private List<JobMetadata> subJobMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobResponse model) {
            this.setJobMetadata(model.jobMetadata);
            this.setSubJobMetadata(model.subJobMetadata);
        }

        public final JobMetadata getJobMetadata() {
            return this.jobMetadata;
        }

        @Override
        public final Builder jobMetadata(JobMetadata jobMetadata) {
            this.jobMetadata = jobMetadata;
            return this;
        }

        public final void setJobMetadata(JobMetadata jobMetadata) {
            this.jobMetadata = jobMetadata;
        }

        public final Collection<JobMetadata> getSubJobMetadata() {
            return this.subJobMetadata;
        }

        @Override
        public final Builder subJobMetadata(Collection<JobMetadata> subJobMetadata) {
            this.subJobMetadata = JobMetadataListCopier.copy(subJobMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subJobMetadata(JobMetadata ... subJobMetadata) {
            this.subJobMetadata(Arrays.asList(subJobMetadata));
            return this;
        }

        public final void setSubJobMetadata(Collection<JobMetadata> subJobMetadata) {
            this.subJobMetadata = JobMetadataListCopier.copy(subJobMetadata);
        }

        @SafeVarargs
        public final void setSubJobMetadata(JobMetadata ... subJobMetadata) {
            this.subJobMetadata(Arrays.asList(subJobMetadata));
        }

        public DescribeJobResponse build() {
            return new DescribeJobResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeJobResponse> {
        public Builder jobMetadata(JobMetadata var1);

        public Builder subJobMetadata(Collection<JobMetadata> var1);

        public Builder subJobMetadata(JobMetadata ... var1);
    }
}

