/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball;

import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.snowball.DefaultSnowballClientBuilder;
import software.amazon.awssdk.services.snowball.SnowballClientBuilder;
import software.amazon.awssdk.services.snowball.model.CancelClusterRequest;
import software.amazon.awssdk.services.snowball.model.CancelClusterResponse;
import software.amazon.awssdk.services.snowball.model.CancelJobRequest;
import software.amazon.awssdk.services.snowball.model.CancelJobResponse;
import software.amazon.awssdk.services.snowball.model.ClusterLimitExceededException;
import software.amazon.awssdk.services.snowball.model.CreateAddressRequest;
import software.amazon.awssdk.services.snowball.model.CreateAddressResponse;
import software.amazon.awssdk.services.snowball.model.CreateClusterRequest;
import software.amazon.awssdk.services.snowball.model.CreateClusterResponse;
import software.amazon.awssdk.services.snowball.model.CreateJobRequest;
import software.amazon.awssdk.services.snowball.model.CreateJobResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressResponse;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesRequest;
import software.amazon.awssdk.services.snowball.model.DescribeAddressesResponse;
import software.amazon.awssdk.services.snowball.model.DescribeClusterRequest;
import software.amazon.awssdk.services.snowball.model.DescribeClusterResponse;
import software.amazon.awssdk.services.snowball.model.DescribeJobRequest;
import software.amazon.awssdk.services.snowball.model.DescribeJobResponse;
import software.amazon.awssdk.services.snowball.model.GetJobManifestRequest;
import software.amazon.awssdk.services.snowball.model.GetJobManifestResponse;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeRequest;
import software.amazon.awssdk.services.snowball.model.GetJobUnlockCodeResponse;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageRequest;
import software.amazon.awssdk.services.snowball.model.GetSnowballUsageResponse;
import software.amazon.awssdk.services.snowball.model.InvalidAddressException;
import software.amazon.awssdk.services.snowball.model.InvalidInputCombinationException;
import software.amazon.awssdk.services.snowball.model.InvalidJobStateException;
import software.amazon.awssdk.services.snowball.model.InvalidNextTokenException;
import software.amazon.awssdk.services.snowball.model.InvalidResourceException;
import software.amazon.awssdk.services.snowball.model.KMSRequestFailedException;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListClusterJobsResponse;
import software.amazon.awssdk.services.snowball.model.ListClustersRequest;
import software.amazon.awssdk.services.snowball.model.ListClustersResponse;
import software.amazon.awssdk.services.snowball.model.ListJobsRequest;
import software.amazon.awssdk.services.snowball.model.ListJobsResponse;
import software.amazon.awssdk.services.snowball.model.SnowballException;
import software.amazon.awssdk.services.snowball.model.UnsupportedAddressException;
import software.amazon.awssdk.services.snowball.model.UpdateClusterRequest;
import software.amazon.awssdk.services.snowball.model.UpdateClusterResponse;
import software.amazon.awssdk.services.snowball.model.UpdateJobRequest;
import software.amazon.awssdk.services.snowball.model.UpdateJobResponse;

public interface SnowballClient
extends AutoCloseable {
    public static final String SERVICE_NAME = "snowball";

    public static SnowballClient create() {
        return (SnowballClient)SnowballClient.builder().build();
    }

    public static SnowballClientBuilder builder() {
        return new DefaultSnowballClientBuilder();
    }

    default public CancelClusterResponse cancelCluster(CancelClusterRequest cancelClusterRequest) throws KMSRequestFailedException, InvalidJobStateException, InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws InvalidResourceException, InvalidJobStateException, KMSRequestFailedException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public CreateAddressResponse createAddress(CreateAddressRequest createAddressRequest) throws InvalidAddressException, UnsupportedAddressException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws InvalidResourceException, KMSRequestFailedException, InvalidInputCombinationException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws InvalidResourceException, KMSRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAddressResponse describeAddress(DescribeAddressRequest describeAddressRequest) throws InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAddressesResponse describeAddresses() throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAddressesResponse describeAddresses(DescribeAddressesRequest describeAddressesRequest) throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws InvalidResourceException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public GetJobManifestResponse getJobManifest(GetJobManifestRequest getJobManifestRequest) throws InvalidResourceException, InvalidJobStateException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public GetJobUnlockCodeResponse getJobUnlockCode(GetJobUnlockCodeRequest getJobUnlockCodeRequest) throws InvalidResourceException, InvalidJobStateException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public GetSnowballUsageResponse getSnowballUsage() throws SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public GetSnowballUsageResponse getSnowballUsage(GetSnowballUsageRequest getSnowballUsageRequest) throws SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public ListClusterJobsResponse listClusterJobs(ListClusterJobsRequest listClusterJobsRequest) throws InvalidResourceException, InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public ListClustersResponse listClusters() throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public ListJobsResponse listJobs() throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws InvalidResourceException, InvalidJobStateException, KMSRequestFailedException, InvalidInputCombinationException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    default public UpdateJobResponse updateJob(UpdateJobRequest updateJobRequest) throws InvalidResourceException, InvalidJobStateException, KMSRequestFailedException, InvalidInputCombinationException, ClusterLimitExceededException, SdkBaseException, SdkClientException, SnowballException {
        throw new UnsupportedOperationException();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

