/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.ReplicationJob;
import software.amazon.awssdk.services.sms.model.ReplicationRun;
import software.amazon.awssdk.services.sms.model.ReplicationRunListCopier;
import software.amazon.awssdk.services.sms.model.SmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReplicationRunsResponse
extends SmsResponse
implements ToCopyableBuilder<Builder, GetReplicationRunsResponse> {
    private static final SdkField<ReplicationJob> REPLICATION_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetReplicationRunsResponse.getter(GetReplicationRunsResponse::replicationJob)).setter(GetReplicationRunsResponse.setter(Builder::replicationJob)).constructor(ReplicationJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJob").build()}).build();
    private static final SdkField<List<ReplicationRun>> REPLICATION_RUN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetReplicationRunsResponse.getter(GetReplicationRunsResponse::replicationRunList)).setter(GetReplicationRunsResponse.setter(Builder::replicationRunList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationRunList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetReplicationRunsResponse.getter(GetReplicationRunsResponse::nextToken)).setter(GetReplicationRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_JOB_FIELD, REPLICATION_RUN_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final ReplicationJob replicationJob;
    private final List<ReplicationRun> replicationRunList;
    private final String nextToken;

    private GetReplicationRunsResponse(BuilderImpl builder) {
        super(builder);
        this.replicationJob = builder.replicationJob;
        this.replicationRunList = builder.replicationRunList;
        this.nextToken = builder.nextToken;
    }

    public ReplicationJob replicationJob() {
        return this.replicationJob;
    }

    public List<ReplicationRun> replicationRunList() {
        return this.replicationRunList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationRunList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReplicationRunsResponse)) {
            return false;
        }
        GetReplicationRunsResponse other = (GetReplicationRunsResponse)((Object)obj);
        return Objects.equals(this.replicationJob(), other.replicationJob()) && Objects.equals(this.replicationRunList(), other.replicationRunList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetReplicationRunsResponse").add("ReplicationJob", (Object)this.replicationJob()).add("ReplicationRunList", this.replicationRunList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicationJob": {
                return Optional.ofNullable(clazz.cast(this.replicationJob()));
            }
            case "replicationRunList": {
                return Optional.ofNullable(clazz.cast(this.replicationRunList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReplicationRunsResponse, T> g) {
        return obj -> g.apply((GetReplicationRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsResponse.BuilderImpl
    implements Builder {
        private ReplicationJob replicationJob;
        private List<ReplicationRun> replicationRunList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReplicationRunsResponse model) {
            super(model);
            this.replicationJob(model.replicationJob);
            this.replicationRunList(model.replicationRunList);
            this.nextToken(model.nextToken);
        }

        public final ReplicationJob.Builder getReplicationJob() {
            return this.replicationJob != null ? this.replicationJob.toBuilder() : null;
        }

        @Override
        public final Builder replicationJob(ReplicationJob replicationJob) {
            this.replicationJob = replicationJob;
            return this;
        }

        public final void setReplicationJob(ReplicationJob.BuilderImpl replicationJob) {
            this.replicationJob = replicationJob != null ? replicationJob.build() : null;
        }

        public final Collection<ReplicationRun.Builder> getReplicationRunList() {
            return this.replicationRunList != null ? (Collection)this.replicationRunList.stream().map(ReplicationRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationRunList(Collection<ReplicationRun> replicationRunList) {
            this.replicationRunList = ReplicationRunListCopier.copy(replicationRunList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRunList(ReplicationRun ... replicationRunList) {
            this.replicationRunList(Arrays.asList(replicationRunList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRunList(Consumer<ReplicationRun.Builder> ... replicationRunList) {
            this.replicationRunList(Stream.of(replicationRunList).map(c -> (ReplicationRun)((ReplicationRun.Builder)ReplicationRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationRunList(Collection<ReplicationRun.BuilderImpl> replicationRunList) {
            this.replicationRunList = ReplicationRunListCopier.copyFromBuilder(replicationRunList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetReplicationRunsResponse build() {
            return new GetReplicationRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReplicationRunsResponse> {
        public Builder replicationJob(ReplicationJob var1);

        default public Builder replicationJob(Consumer<ReplicationJob.Builder> replicationJob) {
            return this.replicationJob((ReplicationJob)((ReplicationJob.Builder)ReplicationJob.builder().applyMutation(replicationJob)).build());
        }

        public Builder replicationRunList(Collection<ReplicationRun> var1);

        public Builder replicationRunList(ReplicationRun ... var1);

        public Builder replicationRunList(Consumer<ReplicationRun.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

