/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sms.SmsAsyncClient;
import software.amazon.awssdk.services.sms.internal.UserAgentUtils;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsRequest;
import software.amazon.awssdk.services.sms.model.GetReplicationRunsResponse;
import software.amazon.awssdk.services.sms.model.ReplicationRun;

public class GetReplicationRunsPublisher
implements SdkPublisher<GetReplicationRunsResponse> {
    private final SmsAsyncClient client;
    private final GetReplicationRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetReplicationRunsPublisher(SmsAsyncClient client, GetReplicationRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetReplicationRunsPublisher(SmsAsyncClient client, GetReplicationRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetReplicationRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetReplicationRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReplicationRun> replicationRunList() {
        Function<GetReplicationRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.replicationRunList() != null) {
                return response.replicationRunList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetReplicationRunsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetReplicationRunsResponseFetcher
    implements AsyncPageFetcher<GetReplicationRunsResponse> {
        private GetReplicationRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetReplicationRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetReplicationRunsResponse> nextPage(GetReplicationRunsResponse previousPage) {
            if (previousPage == null) {
                return GetReplicationRunsPublisher.this.client.getReplicationRuns(GetReplicationRunsPublisher.this.firstRequest);
            }
            return GetReplicationRunsPublisher.this.client.getReplicationRuns((GetReplicationRunsRequest)((Object)GetReplicationRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

