/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.LicenseType;
import software.amazon.awssdk.services.sms.model.ReplicationJobState;
import software.amazon.awssdk.services.sms.model.ReplicationRun;
import software.amazon.awssdk.services.sms.model.ReplicationRunListCopier;
import software.amazon.awssdk.services.sms.model.ServerType;
import software.amazon.awssdk.services.sms.model.VmServer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationJob> {
    private static final SdkField<String> REPLICATION_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationJobId").getter(ReplicationJob.getter(ReplicationJob::replicationJobId)).setter(ReplicationJob.setter(Builder::replicationJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationJobId").build()}).build();
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverId").getter(ReplicationJob.getter(ReplicationJob::serverId)).setter(ReplicationJob.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverId").build()}).build();
    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverType").getter(ReplicationJob.getter(ReplicationJob::serverTypeAsString)).setter(ReplicationJob.setter(Builder::serverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverType").build()}).build();
    private static final SdkField<VmServer> VM_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vmServer").getter(ReplicationJob.getter(ReplicationJob::vmServer)).setter(ReplicationJob.setter(Builder::vmServer)).constructor(VmServer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmServer").build()}).build();
    private static final SdkField<Instant> SEED_REPLICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("seedReplicationTime").getter(ReplicationJob.getter(ReplicationJob::seedReplicationTime)).setter(ReplicationJob.setter(Builder::seedReplicationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seedReplicationTime").build()}).build();
    private static final SdkField<Integer> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("frequency").getter(ReplicationJob.getter(ReplicationJob::frequency)).setter(ReplicationJob.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final SdkField<Boolean> RUN_ONCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("runOnce").getter(ReplicationJob.getter(ReplicationJob::runOnce)).setter(ReplicationJob.setter(Builder::runOnce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runOnce").build()}).build();
    private static final SdkField<Instant> NEXT_REPLICATION_RUN_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("nextReplicationRunStartTime").getter(ReplicationJob.getter(ReplicationJob::nextReplicationRunStartTime)).setter(ReplicationJob.setter(Builder::nextReplicationRunStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextReplicationRunStartTime").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseType").getter(ReplicationJob.getter(ReplicationJob::licenseTypeAsString)).setter(ReplicationJob.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseType").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleName").getter(ReplicationJob.getter(ReplicationJob::roleName)).setter(ReplicationJob.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()}).build();
    private static final SdkField<String> LATEST_AMI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("latestAmiId").getter(ReplicationJob.getter(ReplicationJob::latestAmiId)).setter(ReplicationJob.setter(Builder::latestAmiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAmiId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ReplicationJob.getter(ReplicationJob::stateAsString)).setter(ReplicationJob.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(ReplicationJob.getter(ReplicationJob::statusMessage)).setter(ReplicationJob.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ReplicationJob.getter(ReplicationJob::description)).setter(ReplicationJob.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_RECENT_AMIS_TO_KEEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfRecentAmisToKeep").getter(ReplicationJob.getter(ReplicationJob::numberOfRecentAmisToKeep)).setter(ReplicationJob.setter(Builder::numberOfRecentAmisToKeep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecentAmisToKeep").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("encrypted").getter(ReplicationJob.getter(ReplicationJob::encrypted)).setter(ReplicationJob.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(ReplicationJob.getter(ReplicationJob::kmsKeyId)).setter(ReplicationJob.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<List<ReplicationRun>> REPLICATION_RUN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicationRunList").getter(ReplicationJob.getter(ReplicationJob::replicationRunList)).setter(ReplicationJob.setter(Builder::replicationRunList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationRunList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_JOB_ID_FIELD, SERVER_ID_FIELD, SERVER_TYPE_FIELD, VM_SERVER_FIELD, SEED_REPLICATION_TIME_FIELD, FREQUENCY_FIELD, RUN_ONCE_FIELD, NEXT_REPLICATION_RUN_START_TIME_FIELD, LICENSE_TYPE_FIELD, ROLE_NAME_FIELD, LATEST_AMI_ID_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD, DESCRIPTION_FIELD, NUMBER_OF_RECENT_AMIS_TO_KEEP_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, REPLICATION_RUN_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String replicationJobId;
    private final String serverId;
    private final String serverType;
    private final VmServer vmServer;
    private final Instant seedReplicationTime;
    private final Integer frequency;
    private final Boolean runOnce;
    private final Instant nextReplicationRunStartTime;
    private final String licenseType;
    private final String roleName;
    private final String latestAmiId;
    private final String state;
    private final String statusMessage;
    private final String description;
    private final Integer numberOfRecentAmisToKeep;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final List<ReplicationRun> replicationRunList;

    private ReplicationJob(BuilderImpl builder) {
        this.replicationJobId = builder.replicationJobId;
        this.serverId = builder.serverId;
        this.serverType = builder.serverType;
        this.vmServer = builder.vmServer;
        this.seedReplicationTime = builder.seedReplicationTime;
        this.frequency = builder.frequency;
        this.runOnce = builder.runOnce;
        this.nextReplicationRunStartTime = builder.nextReplicationRunStartTime;
        this.licenseType = builder.licenseType;
        this.roleName = builder.roleName;
        this.latestAmiId = builder.latestAmiId;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.description = builder.description;
        this.numberOfRecentAmisToKeep = builder.numberOfRecentAmisToKeep;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.replicationRunList = builder.replicationRunList;
    }

    public final String replicationJobId() {
        return this.replicationJobId;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final ServerType serverType() {
        return ServerType.fromValue(this.serverType);
    }

    public final String serverTypeAsString() {
        return this.serverType;
    }

    public final VmServer vmServer() {
        return this.vmServer;
    }

    public final Instant seedReplicationTime() {
        return this.seedReplicationTime;
    }

    public final Integer frequency() {
        return this.frequency;
    }

    public final Boolean runOnce() {
        return this.runOnce;
    }

    public final Instant nextReplicationRunStartTime() {
        return this.nextReplicationRunStartTime;
    }

    public final LicenseType licenseType() {
        return LicenseType.fromValue(this.licenseType);
    }

    public final String licenseTypeAsString() {
        return this.licenseType;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final String latestAmiId() {
        return this.latestAmiId;
    }

    public final ReplicationJobState state() {
        return ReplicationJobState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String description() {
        return this.description;
    }

    public final Integer numberOfRecentAmisToKeep() {
        return this.numberOfRecentAmisToKeep;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasReplicationRunList() {
        return this.replicationRunList != null && !(this.replicationRunList instanceof SdkAutoConstructList);
    }

    public final List<ReplicationRun> replicationRunList() {
        return this.replicationRunList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.seedReplicationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.runOnce());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextReplicationRunStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAmiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRecentAmisToKeep());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationRunList() ? this.replicationRunList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationJob)) {
            return false;
        }
        ReplicationJob other = (ReplicationJob)obj;
        return Objects.equals(this.replicationJobId(), other.replicationJobId()) && Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.serverTypeAsString(), other.serverTypeAsString()) && Objects.equals(this.vmServer(), other.vmServer()) && Objects.equals(this.seedReplicationTime(), other.seedReplicationTime()) && Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.runOnce(), other.runOnce()) && Objects.equals(this.nextReplicationRunStartTime(), other.nextReplicationRunStartTime()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.latestAmiId(), other.latestAmiId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.numberOfRecentAmisToKeep(), other.numberOfRecentAmisToKeep()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasReplicationRunList() == other.hasReplicationRunList() && Objects.equals(this.replicationRunList(), other.replicationRunList());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationJob").add("ReplicationJobId", (Object)this.replicationJobId()).add("ServerId", (Object)this.serverId()).add("ServerType", (Object)this.serverTypeAsString()).add("VmServer", (Object)this.vmServer()).add("SeedReplicationTime", (Object)this.seedReplicationTime()).add("Frequency", (Object)this.frequency()).add("RunOnce", (Object)this.runOnce()).add("NextReplicationRunStartTime", (Object)this.nextReplicationRunStartTime()).add("LicenseType", (Object)this.licenseTypeAsString()).add("RoleName", (Object)this.roleName()).add("LatestAmiId", (Object)this.latestAmiId()).add("State", (Object)this.stateAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Description", (Object)this.description()).add("NumberOfRecentAmisToKeep", (Object)this.numberOfRecentAmisToKeep()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ReplicationRunList", this.hasReplicationRunList() ? this.replicationRunList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replicationJobId": {
                return Optional.ofNullable(clazz.cast(this.replicationJobId()));
            }
            case "serverId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "serverType": {
                return Optional.ofNullable(clazz.cast(this.serverTypeAsString()));
            }
            case "vmServer": {
                return Optional.ofNullable(clazz.cast(this.vmServer()));
            }
            case "seedReplicationTime": {
                return Optional.ofNullable(clazz.cast(this.seedReplicationTime()));
            }
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequency()));
            }
            case "runOnce": {
                return Optional.ofNullable(clazz.cast(this.runOnce()));
            }
            case "nextReplicationRunStartTime": {
                return Optional.ofNullable(clazz.cast(this.nextReplicationRunStartTime()));
            }
            case "licenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "roleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "latestAmiId": {
                return Optional.ofNullable(clazz.cast(this.latestAmiId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "numberOfRecentAmisToKeep": {
                return Optional.ofNullable(clazz.cast(this.numberOfRecentAmisToKeep()));
            }
            case "encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "replicationRunList": {
                return Optional.ofNullable(clazz.cast(this.replicationRunList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationJob, T> g) {
        return obj -> g.apply((ReplicationJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationJobId;
        private String serverId;
        private String serverType;
        private VmServer vmServer;
        private Instant seedReplicationTime;
        private Integer frequency;
        private Boolean runOnce;
        private Instant nextReplicationRunStartTime;
        private String licenseType;
        private String roleName;
        private String latestAmiId;
        private String state;
        private String statusMessage;
        private String description;
        private Integer numberOfRecentAmisToKeep;
        private Boolean encrypted;
        private String kmsKeyId;
        private List<ReplicationRun> replicationRunList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationJob model) {
            this.replicationJobId(model.replicationJobId);
            this.serverId(model.serverId);
            this.serverType(model.serverType);
            this.vmServer(model.vmServer);
            this.seedReplicationTime(model.seedReplicationTime);
            this.frequency(model.frequency);
            this.runOnce(model.runOnce);
            this.nextReplicationRunStartTime(model.nextReplicationRunStartTime);
            this.licenseType(model.licenseType);
            this.roleName(model.roleName);
            this.latestAmiId(model.latestAmiId);
            this.state(model.state);
            this.statusMessage(model.statusMessage);
            this.description(model.description);
            this.numberOfRecentAmisToKeep(model.numberOfRecentAmisToKeep);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.replicationRunList(model.replicationRunList);
        }

        public final String getReplicationJobId() {
            return this.replicationJobId;
        }

        @Override
        public final Builder replicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
            return this;
        }

        public final void setReplicationJobId(String replicationJobId) {
            this.replicationJobId = replicationJobId;
        }

        public final String getServerId() {
            return this.serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getServerType() {
            return this.serverType;
        }

        @Override
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType == null ? null : serverType.toString());
            return this;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        public final VmServer.Builder getVmServer() {
            return this.vmServer != null ? this.vmServer.toBuilder() : null;
        }

        @Override
        public final Builder vmServer(VmServer vmServer) {
            this.vmServer = vmServer;
            return this;
        }

        public final void setVmServer(VmServer.BuilderImpl vmServer) {
            this.vmServer = vmServer != null ? vmServer.build() : null;
        }

        public final Instant getSeedReplicationTime() {
            return this.seedReplicationTime;
        }

        @Override
        public final Builder seedReplicationTime(Instant seedReplicationTime) {
            this.seedReplicationTime = seedReplicationTime;
            return this;
        }

        public final void setSeedReplicationTime(Instant seedReplicationTime) {
            this.seedReplicationTime = seedReplicationTime;
        }

        public final Integer getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        public final Boolean getRunOnce() {
            return this.runOnce;
        }

        @Override
        public final Builder runOnce(Boolean runOnce) {
            this.runOnce = runOnce;
            return this;
        }

        public final void setRunOnce(Boolean runOnce) {
            this.runOnce = runOnce;
        }

        public final Instant getNextReplicationRunStartTime() {
            return this.nextReplicationRunStartTime;
        }

        @Override
        public final Builder nextReplicationRunStartTime(Instant nextReplicationRunStartTime) {
            this.nextReplicationRunStartTime = nextReplicationRunStartTime;
            return this;
        }

        public final void setNextReplicationRunStartTime(Instant nextReplicationRunStartTime) {
            this.nextReplicationRunStartTime = nextReplicationRunStartTime;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(LicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getLatestAmiId() {
            return this.latestAmiId;
        }

        @Override
        public final Builder latestAmiId(String latestAmiId) {
            this.latestAmiId = latestAmiId;
            return this;
        }

        public final void setLatestAmiId(String latestAmiId) {
            this.latestAmiId = latestAmiId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReplicationJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getNumberOfRecentAmisToKeep() {
            return this.numberOfRecentAmisToKeep;
        }

        @Override
        public final Builder numberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep) {
            this.numberOfRecentAmisToKeep = numberOfRecentAmisToKeep;
            return this;
        }

        public final void setNumberOfRecentAmisToKeep(Integer numberOfRecentAmisToKeep) {
            this.numberOfRecentAmisToKeep = numberOfRecentAmisToKeep;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final List<ReplicationRun.Builder> getReplicationRunList() {
            List<ReplicationRun.Builder> result = ReplicationRunListCopier.copyToBuilder(this.replicationRunList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder replicationRunList(Collection<ReplicationRun> replicationRunList) {
            this.replicationRunList = ReplicationRunListCopier.copy(replicationRunList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRunList(ReplicationRun ... replicationRunList) {
            this.replicationRunList(Arrays.asList(replicationRunList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationRunList(Consumer<ReplicationRun.Builder> ... replicationRunList) {
            this.replicationRunList(Stream.of(replicationRunList).map(c -> (ReplicationRun)((ReplicationRun.Builder)ReplicationRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationRunList(Collection<ReplicationRun.BuilderImpl> replicationRunList) {
            this.replicationRunList = ReplicationRunListCopier.copyFromBuilder(replicationRunList);
        }

        public ReplicationJob build() {
            return new ReplicationJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationJob> {
        public Builder replicationJobId(String var1);

        public Builder serverId(String var1);

        public Builder serverType(String var1);

        public Builder serverType(ServerType var1);

        public Builder vmServer(VmServer var1);

        default public Builder vmServer(Consumer<VmServer.Builder> vmServer) {
            return this.vmServer((VmServer)((VmServer.Builder)VmServer.builder().applyMutation(vmServer)).build());
        }

        public Builder seedReplicationTime(Instant var1);

        public Builder frequency(Integer var1);

        public Builder runOnce(Boolean var1);

        public Builder nextReplicationRunStartTime(Instant var1);

        public Builder licenseType(String var1);

        public Builder licenseType(LicenseType var1);

        public Builder roleName(String var1);

        public Builder latestAmiId(String var1);

        public Builder state(String var1);

        public Builder state(ReplicationJobState var1);

        public Builder statusMessage(String var1);

        public Builder description(String var1);

        public Builder numberOfRecentAmisToKeep(Integer var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder replicationRunList(Collection<ReplicationRun> var1);

        public Builder replicationRunList(ReplicationRun ... var1);

        public Builder replicationRunList(Consumer<ReplicationRun.Builder> ... var1);
    }
}

