/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.AppSummary;
import software.amazon.awssdk.services.sms.model.ServerGroup;
import software.amazon.awssdk.services.sms.model.ServerGroupsCopier;
import software.amazon.awssdk.services.sms.model.SmsResponse;
import software.amazon.awssdk.services.sms.model.Tag;
import software.amazon.awssdk.services.sms.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAppResponse
extends SmsResponse
implements ToCopyableBuilder<Builder, GetAppResponse> {
    private static final SdkField<AppSummary> APP_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("appSummary").getter(GetAppResponse.getter(GetAppResponse::appSummary)).setter(GetAppResponse.setter(Builder::appSummary)).constructor(AppSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appSummary").build()}).build();
    private static final SdkField<List<ServerGroup>> SERVER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serverGroups").getter(GetAppResponse.getter(GetAppResponse::serverGroups)).setter(GetAppResponse.setter(Builder::serverGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(GetAppResponse.getter(GetAppResponse::tags)).setter(GetAppResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_SUMMARY_FIELD, SERVER_GROUPS_FIELD, TAGS_FIELD));
    private final AppSummary appSummary;
    private final List<ServerGroup> serverGroups;
    private final List<Tag> tags;

    private GetAppResponse(BuilderImpl builder) {
        super(builder);
        this.appSummary = builder.appSummary;
        this.serverGroups = builder.serverGroups;
        this.tags = builder.tags;
    }

    public AppSummary appSummary() {
        return this.appSummary;
    }

    public boolean hasServerGroups() {
        return this.serverGroups != null && !(this.serverGroups instanceof SdkAutoConstructList);
    }

    public List<ServerGroup> serverGroups() {
        return this.serverGroups;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppResponse)) {
            return false;
        }
        GetAppResponse other = (GetAppResponse)((Object)obj);
        return Objects.equals(this.appSummary(), other.appSummary()) && Objects.equals(this.serverGroups(), other.serverGroups()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"GetAppResponse").add("AppSummary", (Object)this.appSummary()).add("ServerGroups", this.serverGroups()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appSummary": {
                return Optional.ofNullable(clazz.cast(this.appSummary()));
            }
            case "serverGroups": {
                return Optional.ofNullable(clazz.cast(this.serverGroups()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAppResponse, T> g) {
        return obj -> g.apply((GetAppResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsResponse.BuilderImpl
    implements Builder {
        private AppSummary appSummary;
        private List<ServerGroup> serverGroups = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppResponse model) {
            super(model);
            this.appSummary(model.appSummary);
            this.serverGroups(model.serverGroups);
            this.tags(model.tags);
        }

        public final AppSummary.Builder getAppSummary() {
            return this.appSummary != null ? this.appSummary.toBuilder() : null;
        }

        @Override
        public final Builder appSummary(AppSummary appSummary) {
            this.appSummary = appSummary;
            return this;
        }

        public final void setAppSummary(AppSummary.BuilderImpl appSummary) {
            this.appSummary = appSummary != null ? appSummary.build() : null;
        }

        public final Collection<ServerGroup.Builder> getServerGroups() {
            return this.serverGroups != null ? (Collection)this.serverGroups.stream().map(ServerGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverGroups(Collection<ServerGroup> serverGroups) {
            this.serverGroups = ServerGroupsCopier.copy(serverGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroups(ServerGroup ... serverGroups) {
            this.serverGroups(Arrays.asList(serverGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroups(Consumer<ServerGroup.Builder> ... serverGroups) {
            this.serverGroups(Stream.of(serverGroups).map(c -> (ServerGroup)((ServerGroup.Builder)ServerGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerGroups(Collection<ServerGroup.BuilderImpl> serverGroups) {
            this.serverGroups = ServerGroupsCopier.copyFromBuilder(serverGroups);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public GetAppResponse build() {
            return new GetAppResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAppResponse> {
        public Builder appSummary(AppSummary var1);

        default public Builder appSummary(Consumer<AppSummary.Builder> appSummary) {
            return this.appSummary((AppSummary)((AppSummary.Builder)AppSummary.builder().applyMutation(appSummary)).build());
        }

        public Builder serverGroups(Collection<ServerGroup> var1);

        public Builder serverGroups(ServerGroup ... var1);

        public Builder serverGroups(Consumer<ServerGroup.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

