/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AppValidationStrategy {
    SSM("SSM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AppValidationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppValidationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AppValidationStrategy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppValidationStrategy> knownValues() {
        return Stream.of(AppValidationStrategy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

