/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.ServerGroupLaunchConfiguration;
import software.amazon.awssdk.services.sms.model.ServerGroupLaunchConfigurationsCopier;
import software.amazon.awssdk.services.sms.model.SmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAppLaunchConfigurationResponse
extends SmsResponse
implements ToCopyableBuilder<Builder, GetAppLaunchConfigurationResponse> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAppLaunchConfigurationResponse.getter(GetAppLaunchConfigurationResponse::appId)).setter(GetAppLaunchConfigurationResponse.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAppLaunchConfigurationResponse.getter(GetAppLaunchConfigurationResponse::roleName)).setter(GetAppLaunchConfigurationResponse.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()}).build();
    private static final SdkField<List<ServerGroupLaunchConfiguration>> SERVER_GROUP_LAUNCH_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetAppLaunchConfigurationResponse.getter(GetAppLaunchConfigurationResponse::serverGroupLaunchConfigurations)).setter(GetAppLaunchConfigurationResponse.setter(Builder::serverGroupLaunchConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupLaunchConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerGroupLaunchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, ROLE_NAME_FIELD, SERVER_GROUP_LAUNCH_CONFIGURATIONS_FIELD));
    private final String appId;
    private final String roleName;
    private final List<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations;

    private GetAppLaunchConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.roleName = builder.roleName;
        this.serverGroupLaunchConfigurations = builder.serverGroupLaunchConfigurations;
    }

    public String appId() {
        return this.appId;
    }

    public String roleName() {
        return this.roleName;
    }

    public boolean hasServerGroupLaunchConfigurations() {
        return this.serverGroupLaunchConfigurations != null && !(this.serverGroupLaunchConfigurations instanceof SdkAutoConstructList);
    }

    public List<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations() {
        return this.serverGroupLaunchConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverGroupLaunchConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppLaunchConfigurationResponse)) {
            return false;
        }
        GetAppLaunchConfigurationResponse other = (GetAppLaunchConfigurationResponse)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.serverGroupLaunchConfigurations(), other.serverGroupLaunchConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"GetAppLaunchConfigurationResponse").add("AppId", (Object)this.appId()).add("RoleName", (Object)this.roleName()).add("ServerGroupLaunchConfigurations", this.serverGroupLaunchConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "roleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "serverGroupLaunchConfigurations": {
                return Optional.ofNullable(clazz.cast(this.serverGroupLaunchConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAppLaunchConfigurationResponse, T> g) {
        return obj -> g.apply((GetAppLaunchConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsResponse.BuilderImpl
    implements Builder {
        private String appId;
        private String roleName;
        private List<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppLaunchConfigurationResponse model) {
            super(model);
            this.appId(model.appId);
            this.roleName(model.roleName);
            this.serverGroupLaunchConfigurations(model.serverGroupLaunchConfigurations);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final Collection<ServerGroupLaunchConfiguration.Builder> getServerGroupLaunchConfigurations() {
            return this.serverGroupLaunchConfigurations != null ? (Collection)this.serverGroupLaunchConfigurations.stream().map(ServerGroupLaunchConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverGroupLaunchConfigurations(Collection<ServerGroupLaunchConfiguration> serverGroupLaunchConfigurations) {
            this.serverGroupLaunchConfigurations = ServerGroupLaunchConfigurationsCopier.copy(serverGroupLaunchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupLaunchConfigurations(ServerGroupLaunchConfiguration ... serverGroupLaunchConfigurations) {
            this.serverGroupLaunchConfigurations(Arrays.asList(serverGroupLaunchConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupLaunchConfigurations(Consumer<ServerGroupLaunchConfiguration.Builder> ... serverGroupLaunchConfigurations) {
            this.serverGroupLaunchConfigurations(Stream.of(serverGroupLaunchConfigurations).map(c -> (ServerGroupLaunchConfiguration)((ServerGroupLaunchConfiguration.Builder)ServerGroupLaunchConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerGroupLaunchConfigurations(Collection<ServerGroupLaunchConfiguration.BuilderImpl> serverGroupLaunchConfigurations) {
            this.serverGroupLaunchConfigurations = ServerGroupLaunchConfigurationsCopier.copyFromBuilder(serverGroupLaunchConfigurations);
        }

        @Override
        public GetAppLaunchConfigurationResponse build() {
            return new GetAppLaunchConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAppLaunchConfigurationResponse> {
        public Builder appId(String var1);

        public Builder roleName(String var1);

        public Builder serverGroupLaunchConfigurations(Collection<ServerGroupLaunchConfiguration> var1);

        public Builder serverGroupLaunchConfigurations(ServerGroupLaunchConfiguration ... var1);

        public Builder serverGroupLaunchConfigurations(Consumer<ServerGroupLaunchConfiguration.Builder> ... var1);
    }
}

