/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sms.model.AppLaunchStatus;
import software.amazon.awssdk.services.sms.model.AppReplicationStatus;
import software.amazon.awssdk.services.sms.model.AppStatus;
import software.amazon.awssdk.services.sms.model.LaunchDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppSummary> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AppSummary.getter(AppSummary::appId)).setter(AppSummary.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AppSummary.getter(AppSummary::name)).setter(AppSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AppSummary.getter(AppSummary::description)).setter(AppSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AppSummary.getter(AppSummary::statusAsString)).setter(AppSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AppSummary.getter(AppSummary::statusMessage)).setter(AppSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> REPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AppSummary.getter(AppSummary::replicationStatusAsString)).setter(AppSummary.setter(Builder::replicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatus").build()}).build();
    private static final SdkField<String> REPLICATION_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AppSummary.getter(AppSummary::replicationStatusMessage)).setter(AppSummary.setter(Builder::replicationStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatusMessage").build()}).build();
    private static final SdkField<Instant> LATEST_REPLICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AppSummary.getter(AppSummary::latestReplicationTime)).setter(AppSummary.setter(Builder::latestReplicationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestReplicationTime").build()}).build();
    private static final SdkField<String> LAUNCH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AppSummary.getter(AppSummary::launchStatusAsString)).setter(AppSummary.setter(Builder::launchStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchStatus").build()}).build();
    private static final SdkField<String> LAUNCH_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AppSummary.getter(AppSummary::launchStatusMessage)).setter(AppSummary.setter(Builder::launchStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchStatusMessage").build()}).build();
    private static final SdkField<LaunchDetails> LAUNCH_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AppSummary.getter(AppSummary::launchDetails)).setter(AppSummary.setter(Builder::launchDetails)).constructor(LaunchDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDetails").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AppSummary.getter(AppSummary::creationTime)).setter(AppSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AppSummary.getter(AppSummary::lastModified)).setter(AppSummary.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AppSummary.getter(AppSummary::roleName)).setter(AppSummary.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()}).build();
    private static final SdkField<Integer> TOTAL_SERVER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AppSummary.getter(AppSummary::totalServerGroups)).setter(AppSummary.setter(Builder::totalServerGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalServerGroups").build()}).build();
    private static final SdkField<Integer> TOTAL_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AppSummary.getter(AppSummary::totalServers)).setter(AppSummary.setter(Builder::totalServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalServers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, REPLICATION_STATUS_FIELD, REPLICATION_STATUS_MESSAGE_FIELD, LATEST_REPLICATION_TIME_FIELD, LAUNCH_STATUS_FIELD, LAUNCH_STATUS_MESSAGE_FIELD, LAUNCH_DETAILS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_FIELD, ROLE_NAME_FIELD, TOTAL_SERVER_GROUPS_FIELD, TOTAL_SERVERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appId;
    private final String name;
    private final String description;
    private final String status;
    private final String statusMessage;
    private final String replicationStatus;
    private final String replicationStatusMessage;
    private final Instant latestReplicationTime;
    private final String launchStatus;
    private final String launchStatusMessage;
    private final LaunchDetails launchDetails;
    private final Instant creationTime;
    private final Instant lastModified;
    private final String roleName;
    private final Integer totalServerGroups;
    private final Integer totalServers;

    private AppSummary(BuilderImpl builder) {
        this.appId = builder.appId;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.replicationStatus = builder.replicationStatus;
        this.replicationStatusMessage = builder.replicationStatusMessage;
        this.latestReplicationTime = builder.latestReplicationTime;
        this.launchStatus = builder.launchStatus;
        this.launchStatusMessage = builder.launchStatusMessage;
        this.launchDetails = builder.launchDetails;
        this.creationTime = builder.creationTime;
        this.lastModified = builder.lastModified;
        this.roleName = builder.roleName;
        this.totalServerGroups = builder.totalServerGroups;
        this.totalServers = builder.totalServers;
    }

    public String appId() {
        return this.appId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public AppStatus status() {
        return AppStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public AppReplicationStatus replicationStatus() {
        return AppReplicationStatus.fromValue(this.replicationStatus);
    }

    public String replicationStatusAsString() {
        return this.replicationStatus;
    }

    public String replicationStatusMessage() {
        return this.replicationStatusMessage;
    }

    public Instant latestReplicationTime() {
        return this.latestReplicationTime;
    }

    public AppLaunchStatus launchStatus() {
        return AppLaunchStatus.fromValue(this.launchStatus);
    }

    public String launchStatusAsString() {
        return this.launchStatus;
    }

    public String launchStatusMessage() {
        return this.launchStatusMessage;
    }

    public LaunchDetails launchDetails() {
        return this.launchDetails;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public String roleName() {
        return this.roleName;
    }

    public Integer totalServerGroups() {
        return this.totalServerGroups;
    }

    public Integer totalServers() {
        return this.totalServers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestReplicationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalServerGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalServers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSummary)) {
            return false;
        }
        AppSummary other = (AppSummary)obj;
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.replicationStatusAsString(), other.replicationStatusAsString()) && Objects.equals(this.replicationStatusMessage(), other.replicationStatusMessage()) && Objects.equals(this.latestReplicationTime(), other.latestReplicationTime()) && Objects.equals(this.launchStatusAsString(), other.launchStatusAsString()) && Objects.equals(this.launchStatusMessage(), other.launchStatusMessage()) && Objects.equals(this.launchDetails(), other.launchDetails()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.totalServerGroups(), other.totalServerGroups()) && Objects.equals(this.totalServers(), other.totalServers());
    }

    public String toString() {
        return ToString.builder((String)"AppSummary").add("AppId", (Object)this.appId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ReplicationStatus", (Object)this.replicationStatusAsString()).add("ReplicationStatusMessage", (Object)this.replicationStatusMessage()).add("LatestReplicationTime", (Object)this.latestReplicationTime()).add("LaunchStatus", (Object)this.launchStatusAsString()).add("LaunchStatusMessage", (Object)this.launchStatusMessage()).add("LaunchDetails", (Object)this.launchDetails()).add("CreationTime", (Object)this.creationTime()).add("LastModified", (Object)this.lastModified()).add("RoleName", (Object)this.roleName()).add("TotalServerGroups", (Object)this.totalServerGroups()).add("TotalServers", (Object)this.totalServers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "replicationStatus": {
                return Optional.ofNullable(clazz.cast(this.replicationStatusAsString()));
            }
            case "replicationStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.replicationStatusMessage()));
            }
            case "latestReplicationTime": {
                return Optional.ofNullable(clazz.cast(this.latestReplicationTime()));
            }
            case "launchStatus": {
                return Optional.ofNullable(clazz.cast(this.launchStatusAsString()));
            }
            case "launchStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.launchStatusMessage()));
            }
            case "launchDetails": {
                return Optional.ofNullable(clazz.cast(this.launchDetails()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "roleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "totalServerGroups": {
                return Optional.ofNullable(clazz.cast(this.totalServerGroups()));
            }
            case "totalServers": {
                return Optional.ofNullable(clazz.cast(this.totalServers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppSummary, T> g) {
        return obj -> g.apply((AppSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appId;
        private String name;
        private String description;
        private String status;
        private String statusMessage;
        private String replicationStatus;
        private String replicationStatusMessage;
        private Instant latestReplicationTime;
        private String launchStatus;
        private String launchStatusMessage;
        private LaunchDetails launchDetails;
        private Instant creationTime;
        private Instant lastModified;
        private String roleName;
        private Integer totalServerGroups;
        private Integer totalServers;

        private BuilderImpl() {
        }

        private BuilderImpl(AppSummary model) {
            this.appId(model.appId);
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.replicationStatus(model.replicationStatus);
            this.replicationStatusMessage(model.replicationStatusMessage);
            this.latestReplicationTime(model.latestReplicationTime);
            this.launchStatus(model.launchStatus);
            this.launchStatusMessage(model.launchStatusMessage);
            this.launchDetails(model.launchDetails);
            this.creationTime(model.creationTime);
            this.lastModified(model.lastModified);
            this.roleName(model.roleName);
            this.totalServerGroups(model.totalServerGroups);
            this.totalServers(model.totalServers);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getReplicationStatus() {
            return this.replicationStatus;
        }

        @Override
        public final Builder replicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
            return this;
        }

        @Override
        public final Builder replicationStatus(AppReplicationStatus replicationStatus) {
            this.replicationStatus(replicationStatus == null ? null : replicationStatus.toString());
            return this;
        }

        public final void setReplicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
        }

        public final String getReplicationStatusMessage() {
            return this.replicationStatusMessage;
        }

        @Override
        public final Builder replicationStatusMessage(String replicationStatusMessage) {
            this.replicationStatusMessage = replicationStatusMessage;
            return this;
        }

        public final void setReplicationStatusMessage(String replicationStatusMessage) {
            this.replicationStatusMessage = replicationStatusMessage;
        }

        public final Instant getLatestReplicationTime() {
            return this.latestReplicationTime;
        }

        @Override
        public final Builder latestReplicationTime(Instant latestReplicationTime) {
            this.latestReplicationTime = latestReplicationTime;
            return this;
        }

        public final void setLatestReplicationTime(Instant latestReplicationTime) {
            this.latestReplicationTime = latestReplicationTime;
        }

        public final String getLaunchStatus() {
            return this.launchStatus;
        }

        @Override
        public final Builder launchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
            return this;
        }

        @Override
        public final Builder launchStatus(AppLaunchStatus launchStatus) {
            this.launchStatus(launchStatus == null ? null : launchStatus.toString());
            return this;
        }

        public final void setLaunchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
        }

        public final String getLaunchStatusMessage() {
            return this.launchStatusMessage;
        }

        @Override
        public final Builder launchStatusMessage(String launchStatusMessage) {
            this.launchStatusMessage = launchStatusMessage;
            return this;
        }

        public final void setLaunchStatusMessage(String launchStatusMessage) {
            this.launchStatusMessage = launchStatusMessage;
        }

        public final LaunchDetails.Builder getLaunchDetails() {
            return this.launchDetails != null ? this.launchDetails.toBuilder() : null;
        }

        @Override
        public final Builder launchDetails(LaunchDetails launchDetails) {
            this.launchDetails = launchDetails;
            return this;
        }

        public final void setLaunchDetails(LaunchDetails.BuilderImpl launchDetails) {
            this.launchDetails = launchDetails != null ? launchDetails.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final Integer getTotalServerGroups() {
            return this.totalServerGroups;
        }

        @Override
        public final Builder totalServerGroups(Integer totalServerGroups) {
            this.totalServerGroups = totalServerGroups;
            return this;
        }

        public final void setTotalServerGroups(Integer totalServerGroups) {
            this.totalServerGroups = totalServerGroups;
        }

        public final Integer getTotalServers() {
            return this.totalServers;
        }

        @Override
        public final Builder totalServers(Integer totalServers) {
            this.totalServers = totalServers;
            return this;
        }

        public final void setTotalServers(Integer totalServers) {
            this.totalServers = totalServers;
        }

        public AppSummary build() {
            return new AppSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppSummary> {
        public Builder appId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(AppStatus var1);

        public Builder statusMessage(String var1);

        public Builder replicationStatus(String var1);

        public Builder replicationStatus(AppReplicationStatus var1);

        public Builder replicationStatusMessage(String var1);

        public Builder latestReplicationTime(Instant var1);

        public Builder launchStatus(String var1);

        public Builder launchStatus(AppLaunchStatus var1);

        public Builder launchStatusMessage(String var1);

        public Builder launchDetails(LaunchDetails var1);

        default public Builder launchDetails(Consumer<LaunchDetails.Builder> launchDetails) {
            return this.launchDetails((LaunchDetails)((LaunchDetails.Builder)LaunchDetails.builder().applyMutation(launchDetails)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastModified(Instant var1);

        public Builder roleName(String var1);

        public Builder totalServerGroups(Integer var1);

        public Builder totalServers(Integer var1);
    }
}

