/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Replication configuration for a server group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerGroupReplicationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerGroupReplicationConfiguration.Builder, ServerGroupReplicationConfiguration> {
    private static final SdkField<String> SERVER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerGroupReplicationConfiguration::serverGroupId)).setter(setter(Builder::serverGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupId").build()).build();

    private static final SdkField<List<ServerReplicationConfiguration>> SERVER_REPLICATION_CONFIGURATIONS_FIELD = SdkField
            .<List<ServerReplicationConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(ServerGroupReplicationConfiguration::serverReplicationConfigurations))
            .setter(setter(Builder::serverReplicationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverReplicationConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerReplicationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerReplicationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_GROUP_ID_FIELD,
            SERVER_REPLICATION_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverGroupId;

    private final List<ServerReplicationConfiguration> serverReplicationConfigurations;

    private ServerGroupReplicationConfiguration(BuilderImpl builder) {
        this.serverGroupId = builder.serverGroupId;
        this.serverReplicationConfigurations = builder.serverReplicationConfigurations;
    }

    /**
     * <p>
     * Identifier of the server group this replication configuration is associated with.
     * </p>
     * 
     * @return Identifier of the server group this replication configuration is associated with.
     */
    public String serverGroupId() {
        return serverGroupId;
    }

    /**
     * Returns true if the ServerReplicationConfigurations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasServerReplicationConfigurations() {
        return serverReplicationConfigurations != null && !(serverReplicationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Replication configuration for servers in the server group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServerReplicationConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Replication configuration for servers in the server group.
     */
    public List<ServerReplicationConfiguration> serverReplicationConfigurations() {
        return serverReplicationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(serverReplicationConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerGroupReplicationConfiguration)) {
            return false;
        }
        ServerGroupReplicationConfiguration other = (ServerGroupReplicationConfiguration) obj;
        return Objects.equals(serverGroupId(), other.serverGroupId())
                && Objects.equals(serverReplicationConfigurations(), other.serverReplicationConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServerGroupReplicationConfiguration").add("ServerGroupId", serverGroupId())
                .add("ServerReplicationConfigurations", serverReplicationConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverGroupId":
            return Optional.ofNullable(clazz.cast(serverGroupId()));
        case "serverReplicationConfigurations":
            return Optional.ofNullable(clazz.cast(serverReplicationConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerGroupReplicationConfiguration, T> g) {
        return obj -> g.apply((ServerGroupReplicationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerGroupReplicationConfiguration> {
        /**
         * <p>
         * Identifier of the server group this replication configuration is associated with.
         * </p>
         * 
         * @param serverGroupId
         *        Identifier of the server group this replication configuration is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupId(String serverGroupId);

        /**
         * <p>
         * Replication configuration for servers in the server group.
         * </p>
         * 
         * @param serverReplicationConfigurations
         *        Replication configuration for servers in the server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverReplicationConfigurations(Collection<ServerReplicationConfiguration> serverReplicationConfigurations);

        /**
         * <p>
         * Replication configuration for servers in the server group.
         * </p>
         * 
         * @param serverReplicationConfigurations
         *        Replication configuration for servers in the server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverReplicationConfigurations(ServerReplicationConfiguration... serverReplicationConfigurations);

        /**
         * <p>
         * Replication configuration for servers in the server group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServerReplicationConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<ServerReplicationConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServerReplicationConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #serverReplicationConfigurations(List<ServerReplicationConfiguration>)}.
         * 
         * @param serverReplicationConfigurations
         *        a consumer that will call methods on {@link List<ServerReplicationConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverReplicationConfigurations(List<ServerReplicationConfiguration>)
         */
        Builder serverReplicationConfigurations(
                Consumer<ServerReplicationConfiguration.Builder>... serverReplicationConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String serverGroupId;

        private List<ServerReplicationConfiguration> serverReplicationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerGroupReplicationConfiguration model) {
            serverGroupId(model.serverGroupId);
            serverReplicationConfigurations(model.serverReplicationConfigurations);
        }

        public final String getServerGroupId() {
            return serverGroupId;
        }

        @Override
        public final Builder serverGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
            return this;
        }

        public final void setServerGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
        }

        public final Collection<ServerReplicationConfiguration.Builder> getServerReplicationConfigurations() {
            return serverReplicationConfigurations != null ? serverReplicationConfigurations.stream()
                    .map(ServerReplicationConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverReplicationConfigurations(
                Collection<ServerReplicationConfiguration> serverReplicationConfigurations) {
            this.serverReplicationConfigurations = ServerReplicationConfigurationsCopier.copy(serverReplicationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverReplicationConfigurations(ServerReplicationConfiguration... serverReplicationConfigurations) {
            serverReplicationConfigurations(Arrays.asList(serverReplicationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverReplicationConfigurations(
                Consumer<ServerReplicationConfiguration.Builder>... serverReplicationConfigurations) {
            serverReplicationConfigurations(Stream.of(serverReplicationConfigurations)
                    .map(c -> ServerReplicationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerReplicationConfigurations(
                Collection<ServerReplicationConfiguration.BuilderImpl> serverReplicationConfigurations) {
            this.serverReplicationConfigurations = ServerReplicationConfigurationsCopier
                    .copyFromBuilder(serverReplicationConfigurations);
        }

        @Override
        public ServerGroupReplicationConfiguration build() {
            return new ServerGroupReplicationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
