/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Launch configuration for a server group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerGroupLaunchConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerGroupLaunchConfiguration.Builder, ServerGroupLaunchConfiguration> {
    private static final SdkField<String> SERVER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerGroupLaunchConfiguration::serverGroupId)).setter(setter(Builder::serverGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupId").build()).build();

    private static final SdkField<Integer> LAUNCH_ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ServerGroupLaunchConfiguration::launchOrder)).setter(setter(Builder::launchOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchOrder").build()).build();

    private static final SdkField<List<ServerLaunchConfiguration>> SERVER_LAUNCH_CONFIGURATIONS_FIELD = SdkField
            .<List<ServerLaunchConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(ServerGroupLaunchConfiguration::serverLaunchConfigurations))
            .setter(setter(Builder::serverLaunchConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverLaunchConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerLaunchConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerLaunchConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_GROUP_ID_FIELD,
            LAUNCH_ORDER_FIELD, SERVER_LAUNCH_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverGroupId;

    private final Integer launchOrder;

    private final List<ServerLaunchConfiguration> serverLaunchConfigurations;

    private ServerGroupLaunchConfiguration(BuilderImpl builder) {
        this.serverGroupId = builder.serverGroupId;
        this.launchOrder = builder.launchOrder;
        this.serverLaunchConfigurations = builder.serverLaunchConfigurations;
    }

    /**
     * <p>
     * Identifier of the server group the launch configuration is associated with.
     * </p>
     * 
     * @return Identifier of the server group the launch configuration is associated with.
     */
    public String serverGroupId() {
        return serverGroupId;
    }

    /**
     * <p>
     * Launch order of servers in the server group.
     * </p>
     * 
     * @return Launch order of servers in the server group.
     */
    public Integer launchOrder() {
        return launchOrder;
    }

    /**
     * Returns true if the ServerLaunchConfigurations property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasServerLaunchConfigurations() {
        return serverLaunchConfigurations != null && !(serverLaunchConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Launch configuration for servers in the server group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServerLaunchConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Launch configuration for servers in the server group.
     */
    public List<ServerLaunchConfiguration> serverLaunchConfigurations() {
        return serverLaunchConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(launchOrder());
        hashCode = 31 * hashCode + Objects.hashCode(serverLaunchConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerGroupLaunchConfiguration)) {
            return false;
        }
        ServerGroupLaunchConfiguration other = (ServerGroupLaunchConfiguration) obj;
        return Objects.equals(serverGroupId(), other.serverGroupId()) && Objects.equals(launchOrder(), other.launchOrder())
                && Objects.equals(serverLaunchConfigurations(), other.serverLaunchConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServerGroupLaunchConfiguration").add("ServerGroupId", serverGroupId())
                .add("LaunchOrder", launchOrder()).add("ServerLaunchConfigurations", serverLaunchConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverGroupId":
            return Optional.ofNullable(clazz.cast(serverGroupId()));
        case "launchOrder":
            return Optional.ofNullable(clazz.cast(launchOrder()));
        case "serverLaunchConfigurations":
            return Optional.ofNullable(clazz.cast(serverLaunchConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerGroupLaunchConfiguration, T> g) {
        return obj -> g.apply((ServerGroupLaunchConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerGroupLaunchConfiguration> {
        /**
         * <p>
         * Identifier of the server group the launch configuration is associated with.
         * </p>
         * 
         * @param serverGroupId
         *        Identifier of the server group the launch configuration is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupId(String serverGroupId);

        /**
         * <p>
         * Launch order of servers in the server group.
         * </p>
         * 
         * @param launchOrder
         *        Launch order of servers in the server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchOrder(Integer launchOrder);

        /**
         * <p>
         * Launch configuration for servers in the server group.
         * </p>
         * 
         * @param serverLaunchConfigurations
         *        Launch configuration for servers in the server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverLaunchConfigurations(Collection<ServerLaunchConfiguration> serverLaunchConfigurations);

        /**
         * <p>
         * Launch configuration for servers in the server group.
         * </p>
         * 
         * @param serverLaunchConfigurations
         *        Launch configuration for servers in the server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverLaunchConfigurations(ServerLaunchConfiguration... serverLaunchConfigurations);

        /**
         * <p>
         * Launch configuration for servers in the server group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServerLaunchConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<ServerLaunchConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServerLaunchConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #serverLaunchConfigurations(List<ServerLaunchConfiguration>)}.
         * 
         * @param serverLaunchConfigurations
         *        a consumer that will call methods on {@link List<ServerLaunchConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverLaunchConfigurations(List<ServerLaunchConfiguration>)
         */
        Builder serverLaunchConfigurations(Consumer<ServerLaunchConfiguration.Builder>... serverLaunchConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String serverGroupId;

        private Integer launchOrder;

        private List<ServerLaunchConfiguration> serverLaunchConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerGroupLaunchConfiguration model) {
            serverGroupId(model.serverGroupId);
            launchOrder(model.launchOrder);
            serverLaunchConfigurations(model.serverLaunchConfigurations);
        }

        public final String getServerGroupId() {
            return serverGroupId;
        }

        @Override
        public final Builder serverGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
            return this;
        }

        public final void setServerGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
        }

        public final Integer getLaunchOrder() {
            return launchOrder;
        }

        @Override
        public final Builder launchOrder(Integer launchOrder) {
            this.launchOrder = launchOrder;
            return this;
        }

        public final void setLaunchOrder(Integer launchOrder) {
            this.launchOrder = launchOrder;
        }

        public final Collection<ServerLaunchConfiguration.Builder> getServerLaunchConfigurations() {
            return serverLaunchConfigurations != null ? serverLaunchConfigurations.stream()
                    .map(ServerLaunchConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverLaunchConfigurations(Collection<ServerLaunchConfiguration> serverLaunchConfigurations) {
            this.serverLaunchConfigurations = ServerLaunchConfigurationsCopier.copy(serverLaunchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverLaunchConfigurations(ServerLaunchConfiguration... serverLaunchConfigurations) {
            serverLaunchConfigurations(Arrays.asList(serverLaunchConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverLaunchConfigurations(Consumer<ServerLaunchConfiguration.Builder>... serverLaunchConfigurations) {
            serverLaunchConfigurations(Stream.of(serverLaunchConfigurations)
                    .map(c -> ServerLaunchConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerLaunchConfigurations(
                Collection<ServerLaunchConfiguration.BuilderImpl> serverLaunchConfigurations) {
            this.serverLaunchConfigurations = ServerLaunchConfigurationsCopier.copyFromBuilder(serverLaunchConfigurations);
        }

        @Override
        public ServerGroupLaunchConfiguration build() {
            return new ServerGroupLaunchConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
