/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sms.model.ServerGroupReplicationConfiguration;
import software.amazon.awssdk.services.sms.model.ServerGroupReplicationConfigurationsCopier;
import software.amazon.awssdk.services.sms.model.SmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAppReplicationConfigurationResponse
extends SmsResponse
implements ToCopyableBuilder<Builder, GetAppReplicationConfigurationResponse> {
    private static final SdkField<List<ServerGroupReplicationConfiguration>> SERVER_GROUP_REPLICATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetAppReplicationConfigurationResponse.getter(GetAppReplicationConfigurationResponse::serverGroupReplicationConfigurations)).setter(GetAppReplicationConfigurationResponse.setter(Builder::serverGroupReplicationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupReplicationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerGroupReplicationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_GROUP_REPLICATION_CONFIGURATIONS_FIELD));
    private final List<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations;

    private GetAppReplicationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.serverGroupReplicationConfigurations = builder.serverGroupReplicationConfigurations;
    }

    public boolean hasServerGroupReplicationConfigurations() {
        return this.serverGroupReplicationConfigurations != null && !(this.serverGroupReplicationConfigurations instanceof SdkAutoConstructList);
    }

    public List<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations() {
        return this.serverGroupReplicationConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverGroupReplicationConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppReplicationConfigurationResponse)) {
            return false;
        }
        GetAppReplicationConfigurationResponse other = (GetAppReplicationConfigurationResponse)((Object)obj);
        return Objects.equals(this.serverGroupReplicationConfigurations(), other.serverGroupReplicationConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"GetAppReplicationConfigurationResponse").add("ServerGroupReplicationConfigurations", this.serverGroupReplicationConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serverGroupReplicationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.serverGroupReplicationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAppReplicationConfigurationResponse, T> g) {
        return obj -> g.apply((GetAppReplicationConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SmsResponse.BuilderImpl
    implements Builder {
        private List<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppReplicationConfigurationResponse model) {
            super(model);
            this.serverGroupReplicationConfigurations(model.serverGroupReplicationConfigurations);
        }

        public final Collection<ServerGroupReplicationConfiguration.Builder> getServerGroupReplicationConfigurations() {
            return this.serverGroupReplicationConfigurations != null ? (Collection)this.serverGroupReplicationConfigurations.stream().map(ServerGroupReplicationConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverGroupReplicationConfigurations(Collection<ServerGroupReplicationConfiguration> serverGroupReplicationConfigurations) {
            this.serverGroupReplicationConfigurations = ServerGroupReplicationConfigurationsCopier.copy(serverGroupReplicationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupReplicationConfigurations(ServerGroupReplicationConfiguration ... serverGroupReplicationConfigurations) {
            this.serverGroupReplicationConfigurations(Arrays.asList(serverGroupReplicationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverGroupReplicationConfigurations(Consumer<ServerGroupReplicationConfiguration.Builder> ... serverGroupReplicationConfigurations) {
            this.serverGroupReplicationConfigurations(Stream.of(serverGroupReplicationConfigurations).map(c -> (ServerGroupReplicationConfiguration)((ServerGroupReplicationConfiguration.Builder)ServerGroupReplicationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerGroupReplicationConfigurations(Collection<ServerGroupReplicationConfiguration.BuilderImpl> serverGroupReplicationConfigurations) {
            this.serverGroupReplicationConfigurations = ServerGroupReplicationConfigurationsCopier.copyFromBuilder(serverGroupReplicationConfigurations);
        }

        @Override
        public GetAppReplicationConfigurationResponse build() {
            return new GetAppReplicationConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAppReplicationConfigurationResponse> {
        public Builder serverGroupReplicationConfigurations(Collection<ServerGroupReplicationConfiguration> var1);

        public Builder serverGroupReplicationConfigurations(ServerGroupReplicationConfiguration ... var1);

        public Builder serverGroupReplicationConfigurations(Consumer<ServerGroupReplicationConfiguration.Builder> ... var1);
    }
}

