/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A logical grouping of servers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerGroup implements SdkPojo, Serializable, ToCopyableBuilder<ServerGroup.Builder, ServerGroup> {
    private static final SdkField<String> SERVER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerGroup::serverGroupId)).setter(setter(Builder::serverGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverGroupId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<Server>> SERVER_LIST_FIELD = SdkField
            .<List<Server>> builder(MarshallingType.LIST)
            .getter(getter(ServerGroup::serverList))
            .setter(setter(Builder::serverList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Server> builder(MarshallingType.SDK_POJO)
                                            .constructor(Server::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_GROUP_ID_FIELD,
            NAME_FIELD, SERVER_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverGroupId;

    private final String name;

    private final List<Server> serverList;

    private ServerGroup(BuilderImpl builder) {
        this.serverGroupId = builder.serverGroupId;
        this.name = builder.name;
        this.serverList = builder.serverList;
    }

    /**
     * <p>
     * Identifier of a server group.
     * </p>
     * 
     * @return Identifier of a server group.
     */
    public String serverGroupId() {
        return serverGroupId;
    }

    /**
     * <p>
     * Name of a server group.
     * </p>
     * 
     * @return Name of a server group.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the ServerList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasServerList() {
        return serverList != null && !(serverList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of servers belonging to a server group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServerList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of servers belonging to a server group.
     */
    public List<Server> serverList() {
        return serverList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(serverList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerGroup)) {
            return false;
        }
        ServerGroup other = (ServerGroup) obj;
        return Objects.equals(serverGroupId(), other.serverGroupId()) && Objects.equals(name(), other.name())
                && Objects.equals(serverList(), other.serverList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServerGroup").add("ServerGroupId", serverGroupId()).add("Name", name())
                .add("ServerList", serverList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverGroupId":
            return Optional.ofNullable(clazz.cast(serverGroupId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "serverList":
            return Optional.ofNullable(clazz.cast(serverList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerGroup, T> g) {
        return obj -> g.apply((ServerGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerGroup> {
        /**
         * <p>
         * Identifier of a server group.
         * </p>
         * 
         * @param serverGroupId
         *        Identifier of a server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverGroupId(String serverGroupId);

        /**
         * <p>
         * Name of a server group.
         * </p>
         * 
         * @param name
         *        Name of a server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * List of servers belonging to a server group.
         * </p>
         * 
         * @param serverList
         *        List of servers belonging to a server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverList(Collection<Server> serverList);

        /**
         * <p>
         * List of servers belonging to a server group.
         * </p>
         * 
         * @param serverList
         *        List of servers belonging to a server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverList(Server... serverList);

        /**
         * <p>
         * List of servers belonging to a server group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Server>.Builder} avoiding the need to
         * create one manually via {@link List<Server>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Server>.Builder#build()} is called immediately and its
         * result is passed to {@link #serverList(List<Server>)}.
         * 
         * @param serverList
         *        a consumer that will call methods on {@link List<Server>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverList(List<Server>)
         */
        Builder serverList(Consumer<Server.Builder>... serverList);
    }

    static final class BuilderImpl implements Builder {
        private String serverGroupId;

        private String name;

        private List<Server> serverList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServerGroup model) {
            serverGroupId(model.serverGroupId);
            name(model.name);
            serverList(model.serverList);
        }

        public final String getServerGroupId() {
            return serverGroupId;
        }

        @Override
        public final Builder serverGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
            return this;
        }

        public final void setServerGroupId(String serverGroupId) {
            this.serverGroupId = serverGroupId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Server.Builder> getServerList() {
            return serverList != null ? serverList.stream().map(Server::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverList(Collection<Server> serverList) {
            this.serverList = ServerListCopier.copy(serverList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverList(Server... serverList) {
            serverList(Arrays.asList(serverList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverList(Consumer<Server.Builder>... serverList) {
            serverList(Stream.of(serverList).map(c -> Server.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerList(Collection<Server.BuilderImpl> serverList) {
            this.serverList = ServerListCopier.copyFromBuilder(serverList);
        }

        @Override
        public ServerGroup build() {
            return new ServerGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
