/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.sms.transform.VmServerAddressMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VmServerAddress
implements StructuredPojo,
ToCopyableBuilder<Builder, VmServerAddress> {
    private final String vmManagerId;
    private final String vmId;

    private VmServerAddress(BuilderImpl builder) {
        this.vmManagerId = builder.vmManagerId;
        this.vmId = builder.vmId;
    }

    public String vmManagerId() {
        return this.vmManagerId;
    }

    public String vmId() {
        return this.vmId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vmManagerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vmId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VmServerAddress)) {
            return false;
        }
        VmServerAddress other = (VmServerAddress)obj;
        return Objects.equals(this.vmManagerId(), other.vmManagerId()) && Objects.equals(this.vmId(), other.vmId());
    }

    public String toString() {
        return ToString.builder((String)"VmServerAddress").add("VmManagerId", (Object)this.vmManagerId()).add("VmId", (Object)this.vmId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vmManagerId": {
                return Optional.ofNullable(clazz.cast(this.vmManagerId()));
            }
            case "vmId": {
                return Optional.ofNullable(clazz.cast(this.vmId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VmServerAddressMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String vmManagerId;
        private String vmId;

        private BuilderImpl() {
        }

        private BuilderImpl(VmServerAddress model) {
            this.vmManagerId(model.vmManagerId);
            this.vmId(model.vmId);
        }

        public final String getVmManagerId() {
            return this.vmManagerId;
        }

        @Override
        public final Builder vmManagerId(String vmManagerId) {
            this.vmManagerId = vmManagerId;
            return this;
        }

        public final void setVmManagerId(String vmManagerId) {
            this.vmManagerId = vmManagerId;
        }

        public final String getVmId() {
            return this.vmId;
        }

        @Override
        public final Builder vmId(String vmId) {
            this.vmId = vmId;
            return this;
        }

        public final void setVmId(String vmId) {
            this.vmId = vmId;
        }

        public VmServerAddress build() {
            return new VmServerAddress(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VmServerAddress> {
        public Builder vmManagerId(String var1);

        public Builder vmId(String var1);
    }
}

