/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sms.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.sms.model.LicenseType;
import software.amazon.awssdk.services.sms.model.SmsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicationJobRequest
extends SmsRequest
implements ToCopyableBuilder<Builder, CreateReplicationJobRequest> {
    private final String serverId;
    private final Instant seedReplicationTime;
    private final Integer frequency;
    private final String licenseType;
    private final String roleName;
    private final String description;

    private CreateReplicationJobRequest(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.seedReplicationTime = builder.seedReplicationTime;
        this.frequency = builder.frequency;
        this.licenseType = builder.licenseType;
        this.roleName = builder.roleName;
        this.description = builder.description;
    }

    public String serverId() {
        return this.serverId;
    }

    public Instant seedReplicationTime() {
        return this.seedReplicationTime;
    }

    public Integer frequency() {
        return this.frequency;
    }

    public LicenseType licenseType() {
        return LicenseType.fromValue(this.licenseType);
    }

    public String licenseTypeAsString() {
        return this.licenseType;
    }

    public String roleName() {
        return this.roleName;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.seedReplicationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationJobRequest)) {
            return false;
        }
        CreateReplicationJobRequest other = (CreateReplicationJobRequest)((Object)obj);
        return Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.seedReplicationTime(), other.seedReplicationTime()) && Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"CreateReplicationJobRequest").add("ServerId", (Object)this.serverId()).add("SeedReplicationTime", (Object)this.seedReplicationTime()).add("Frequency", (Object)this.frequency()).add("LicenseType", (Object)this.licenseTypeAsString()).add("RoleName", (Object)this.roleName()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serverId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "seedReplicationTime": {
                return Optional.ofNullable(clazz.cast(this.seedReplicationTime()));
            }
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequency()));
            }
            case "licenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "roleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SmsRequest.BuilderImpl
    implements Builder {
        private String serverId;
        private Instant seedReplicationTime;
        private Integer frequency;
        private String licenseType;
        private String roleName;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationJobRequest model) {
            super(model);
            this.serverId(model.serverId);
            this.seedReplicationTime(model.seedReplicationTime);
            this.frequency(model.frequency);
            this.licenseType(model.licenseType);
            this.roleName(model.roleName);
            this.description(model.description);
        }

        public final String getServerId() {
            return this.serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final Instant getSeedReplicationTime() {
            return this.seedReplicationTime;
        }

        @Override
        public final Builder seedReplicationTime(Instant seedReplicationTime) {
            this.seedReplicationTime = seedReplicationTime;
            return this;
        }

        public final void setSeedReplicationTime(Instant seedReplicationTime) {
            this.seedReplicationTime = seedReplicationTime;
        }

        public final Integer getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(LicenseType licenseType) {
            this.licenseType(licenseType.toString());
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationJobRequest build() {
            return new CreateReplicationJobRequest(this);
        }
    }

    public static interface Builder
    extends SmsRequest.Builder,
    CopyableBuilder<Builder, CreateReplicationJobRequest> {
        public Builder serverId(String var1);

        public Builder seedReplicationTime(Instant var1);

        public Builder frequency(Integer var1);

        public Builder licenseType(String var1);

        public Builder licenseType(LicenseType var1);

        public Builder roleName(String var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

