/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.simspaceweaver.model.S3Destination;
import software.amazon.awssdk.services.simspaceweaver.model.SimSpaceWeaverRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSnapshotRequest
extends SimSpaceWeaverRequest
implements ToCopyableBuilder<Builder, CreateSnapshotRequest> {
    private static final SdkField<S3Destination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(CreateSnapshotRequest.getter(CreateSnapshotRequest::destination)).setter(CreateSnapshotRequest.setter(Builder::destination)).constructor(S3Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> SIMULATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Simulation").getter(CreateSnapshotRequest.getter(CreateSnapshotRequest::simulation)).setter(CreateSnapshotRequest.setter(Builder::simulation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Simulation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, SIMULATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSnapshotRequest.memberNameToFieldInitializer();
    private final S3Destination destination;
    private final String simulation;

    private CreateSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.destination = builder.destination;
        this.simulation = builder.simulation;
    }

    public final S3Destination destination() {
        return this.destination;
    }

    public final String simulation() {
        return this.simulation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.simulation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotRequest)) {
            return false;
        }
        CreateSnapshotRequest other = (CreateSnapshotRequest)((Object)obj);
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.simulation(), other.simulation());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSnapshotRequest").add("Destination", (Object)this.destination()).add("Simulation", (Object)this.simulation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Simulation": {
                return Optional.ofNullable(clazz.cast(this.simulation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Destination", DESTINATION_FIELD);
        map.put("Simulation", SIMULATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotRequest, T> g) {
        return obj -> g.apply((CreateSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SimSpaceWeaverRequest.BuilderImpl
    implements Builder {
        private S3Destination destination;
        private String simulation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotRequest model) {
            super(model);
            this.destination(model.destination);
            this.simulation(model.simulation);
        }

        public final S3Destination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(S3Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(S3Destination destination) {
            this.destination = destination;
            return this;
        }

        public final String getSimulation() {
            return this.simulation;
        }

        public final void setSimulation(String simulation) {
            this.simulation = simulation;
        }

        @Override
        public final Builder simulation(String simulation) {
            this.simulation = simulation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSnapshotRequest build() {
            return new CreateSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SimSpaceWeaverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSnapshotRequest> {
        public Builder destination(S3Destination var1);

        default public Builder destination(Consumer<S3Destination.Builder> destination) {
            return this.destination((S3Destination)((S3Destination.Builder)S3Destination.builder().applyMutation(destination)).build());
        }

        public Builder simulation(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

