/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.simspaceweaver.model.AppPortMappingsCopier;
import software.amazon.awssdk.services.simspaceweaver.model.SimulationAppPortMapping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimulationAppEndpointInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SimulationAppEndpointInfo> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Address").getter(SimulationAppEndpointInfo.getter(SimulationAppEndpointInfo::address)).setter(SimulationAppEndpointInfo.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<List<SimulationAppPortMapping>> INGRESS_PORT_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IngressPortMappings").getter(SimulationAppEndpointInfo.getter(SimulationAppEndpointInfo::ingressPortMappings)).setter(SimulationAppEndpointInfo.setter(Builder::ingressPortMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressPortMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationAppPortMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, INGRESS_PORT_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SimulationAppEndpointInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String address;
    private final List<SimulationAppPortMapping> ingressPortMappings;

    private SimulationAppEndpointInfo(BuilderImpl builder) {
        this.address = builder.address;
        this.ingressPortMappings = builder.ingressPortMappings;
    }

    public final String address() {
        return this.address;
    }

    public final boolean hasIngressPortMappings() {
        return this.ingressPortMappings != null && !(this.ingressPortMappings instanceof SdkAutoConstructList);
    }

    public final List<SimulationAppPortMapping> ingressPortMappings() {
        return this.ingressPortMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIngressPortMappings() ? this.ingressPortMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationAppEndpointInfo)) {
            return false;
        }
        SimulationAppEndpointInfo other = (SimulationAppEndpointInfo)obj;
        return Objects.equals(this.address(), other.address()) && this.hasIngressPortMappings() == other.hasIngressPortMappings() && Objects.equals(this.ingressPortMappings(), other.ingressPortMappings());
    }

    public final String toString() {
        return ToString.builder((String)"SimulationAppEndpointInfo").add("Address", (Object)this.address()).add("IngressPortMappings", this.hasIngressPortMappings() ? this.ingressPortMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "IngressPortMappings": {
                return Optional.ofNullable(clazz.cast(this.ingressPortMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Address", ADDRESS_FIELD);
        map.put("IngressPortMappings", INGRESS_PORT_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SimulationAppEndpointInfo, T> g) {
        return obj -> g.apply((SimulationAppEndpointInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String address;
        private List<SimulationAppPortMapping> ingressPortMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationAppEndpointInfo model) {
            this.address(model.address);
            this.ingressPortMappings(model.ingressPortMappings);
        }

        public final String getAddress() {
            return this.address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final List<SimulationAppPortMapping.Builder> getIngressPortMappings() {
            List<SimulationAppPortMapping.Builder> result = AppPortMappingsCopier.copyToBuilder(this.ingressPortMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngressPortMappings(Collection<SimulationAppPortMapping.BuilderImpl> ingressPortMappings) {
            this.ingressPortMappings = AppPortMappingsCopier.copyFromBuilder(ingressPortMappings);
        }

        @Override
        public final Builder ingressPortMappings(Collection<SimulationAppPortMapping> ingressPortMappings) {
            this.ingressPortMappings = AppPortMappingsCopier.copy(ingressPortMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPortMappings(SimulationAppPortMapping ... ingressPortMappings) {
            this.ingressPortMappings(Arrays.asList(ingressPortMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressPortMappings(Consumer<SimulationAppPortMapping.Builder> ... ingressPortMappings) {
            this.ingressPortMappings(Stream.of(ingressPortMappings).map(c -> (SimulationAppPortMapping)((SimulationAppPortMapping.Builder)SimulationAppPortMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SimulationAppEndpointInfo build() {
            return new SimulationAppEndpointInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SimulationAppEndpointInfo> {
        public Builder address(String var1);

        public Builder ingressPortMappings(Collection<SimulationAppPortMapping> var1);

        public Builder ingressPortMappings(SimulationAppPortMapping ... var1);

        public Builder ingressPortMappings(Consumer<SimulationAppPortMapping.Builder> ... var1);
    }
}

