/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.simspaceweaver.model.SimSpaceWeaverResponse;
import software.amazon.awssdk.services.simspaceweaver.model.SimulationListCopier;
import software.amazon.awssdk.services.simspaceweaver.model.SimulationMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSimulationsResponse
extends SimSpaceWeaverResponse
implements ToCopyableBuilder<Builder, ListSimulationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSimulationsResponse.getter(ListSimulationsResponse::nextToken)).setter(ListSimulationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SimulationMetadata>> SIMULATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Simulations").getter(ListSimulationsResponse.getter(ListSimulationsResponse::simulations)).setter(ListSimulationsResponse.setter(Builder::simulations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Simulations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SIMULATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSimulationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SimulationMetadata> simulations;

    private ListSimulationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.simulations = builder.simulations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSimulations() {
        return this.simulations != null && !(this.simulations instanceof SdkAutoConstructList);
    }

    public final List<SimulationMetadata> simulations() {
        return this.simulations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSimulations() ? this.simulations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSimulationsResponse)) {
            return false;
        }
        ListSimulationsResponse other = (ListSimulationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSimulations() == other.hasSimulations() && Objects.equals(this.simulations(), other.simulations());
    }

    public final String toString() {
        return ToString.builder((String)"ListSimulationsResponse").add("NextToken", (Object)this.nextToken()).add("Simulations", this.hasSimulations() ? this.simulations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Simulations": {
                return Optional.ofNullable(clazz.cast(this.simulations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Simulations", SIMULATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSimulationsResponse, T> g) {
        return obj -> g.apply((ListSimulationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SimSpaceWeaverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SimulationMetadata> simulations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSimulationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.simulations(model.simulations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SimulationMetadata.Builder> getSimulations() {
            List<SimulationMetadata.Builder> result = SimulationListCopier.copyToBuilder(this.simulations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSimulations(Collection<SimulationMetadata.BuilderImpl> simulations) {
            this.simulations = SimulationListCopier.copyFromBuilder(simulations);
        }

        @Override
        public final Builder simulations(Collection<SimulationMetadata> simulations) {
            this.simulations = SimulationListCopier.copy(simulations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulations(SimulationMetadata ... simulations) {
            this.simulations(Arrays.asList(simulations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulations(Consumer<SimulationMetadata.Builder> ... simulations) {
            this.simulations(Stream.of(simulations).map(c -> (SimulationMetadata)((SimulationMetadata.Builder)SimulationMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSimulationsResponse build() {
            return new ListSimulationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SimSpaceWeaverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSimulationsResponse> {
        public Builder nextToken(String var1);

        public Builder simulations(Collection<SimulationMetadata> var1);

        public Builder simulations(SimulationMetadata ... var1);

        public Builder simulations(Consumer<SimulationMetadata.Builder> ... var1);
    }
}

