/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.simspaceweaver.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.simspaceweaver.SimSpaceWeaverAsyncClient;
import software.amazon.awssdk.services.simspaceweaver.internal.UserAgentUtils;
import software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsRequest;
import software.amazon.awssdk.services.simspaceweaver.model.ListSimulationsResponse;

public class ListSimulationsPublisher
implements SdkPublisher<ListSimulationsResponse> {
    private final SimSpaceWeaverAsyncClient client;
    private final ListSimulationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSimulationsPublisher(SimSpaceWeaverAsyncClient client, ListSimulationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSimulationsPublisher(SimSpaceWeaverAsyncClient client, ListSimulationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSimulationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSimulationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSimulationsResponseFetcher
    implements AsyncPageFetcher<ListSimulationsResponse> {
        private ListSimulationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSimulationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSimulationsResponse> nextPage(ListSimulationsResponse previousPage) {
            if (previousPage == null) {
                return ListSimulationsPublisher.this.client.listSimulations(ListSimulationsPublisher.this.firstRequest);
            }
            return ListSimulationsPublisher.this.client.listSimulations((ListSimulationsRequest)((Object)ListSimulationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

