/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.signin.DefaultSigninClientBuilder;
import software.amazon.awssdk.services.signin.SigninClientBuilder;
import software.amazon.awssdk.services.signin.SigninServiceClientConfiguration;
import software.amazon.awssdk.services.signin.model.AccessDeniedException;
import software.amazon.awssdk.services.signin.model.CreateOAuth2TokenRequest;
import software.amazon.awssdk.services.signin.model.CreateOAuth2TokenResponse;
import software.amazon.awssdk.services.signin.model.InternalServerException;
import software.amazon.awssdk.services.signin.model.SigninException;
import software.amazon.awssdk.services.signin.model.TooManyRequestsErrorException;
import software.amazon.awssdk.services.signin.model.ValidationException;

@SdkPublicApi
@ThreadSafe
public interface SigninClient
extends AwsClient {
    public static final String SERVICE_NAME = "signin";
    public static final String SERVICE_METADATA_ID = "signin";

    default public CreateOAuth2TokenResponse createOAuth2Token(CreateOAuth2TokenRequest createOAuth2TokenRequest) throws TooManyRequestsErrorException, InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, SigninException {
        throw new UnsupportedOperationException();
    }

    default public CreateOAuth2TokenResponse createOAuth2Token(Consumer<CreateOAuth2TokenRequest.Builder> createOAuth2TokenRequest) throws TooManyRequestsErrorException, InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, SigninException {
        return this.createOAuth2Token((CreateOAuth2TokenRequest)((Object)((CreateOAuth2TokenRequest.Builder)CreateOAuth2TokenRequest.builder().applyMutation(createOAuth2TokenRequest)).build()));
    }

    public static SigninClient create() {
        return (SigninClient)SigninClient.builder().build();
    }

    public static SigninClientBuilder builder() {
        return new DefaultSigninClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"signin");
    }

    default public SigninServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

