/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.internal;

import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.services.signin.internal.EcKeyLoader;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public class DpopIdentity
implements Identity {
    private final ECPublicKey publicKey;
    private final ECPrivateKey privateKey;

    private DpopIdentity(ECPublicKey publicKey, ECPrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public static DpopIdentity create(ECPublicKey publicKey, ECPrivateKey privateKey) {
        return new DpopIdentity(publicKey, privateKey);
    }

    public static DpopIdentity create(String dpopKeyPem) {
        Pair<ECPrivateKey, ECPublicKey> keys = EcKeyLoader.loadSec1Pem(dpopKeyPem);
        return new DpopIdentity((ECPublicKey)keys.right(), (ECPrivateKey)keys.left());
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

