/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.internal;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.ResolveIdentityRequest;
import software.amazon.awssdk.services.signin.SigninServiceClientConfiguration;
import software.amazon.awssdk.services.signin.auth.scheme.SigninAuthSchemeParams;
import software.amazon.awssdk.services.signin.auth.scheme.SigninAuthSchemeProvider;
import software.amazon.awssdk.services.signin.internal.DpopAuthScheme;
import software.amazon.awssdk.services.signin.internal.DpopIdentity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DpopAuthPlugin
implements SdkPlugin {
    private final String dpopKeyPem;

    private DpopAuthPlugin(String dpopKeyPem) {
        this.dpopKeyPem = (String)Validate.paramNotNull((Object)dpopKeyPem, (String)"dpopKeyPem");
    }

    public static DpopAuthPlugin create(String dpopKeyPem) {
        return new DpopAuthPlugin(dpopKeyPem);
    }

    public void configureClient(SdkServiceClientConfiguration.Builder config) {
        SigninServiceClientConfiguration.Builder scb = (SigninServiceClientConfiguration.Builder)Validate.isInstanceOf(SigninServiceClientConfiguration.Builder.class, (Object)config, (String)"DpopAuthPlugin must be applied to a SigninServiceClient", (Object[])new Object[0]);
        scb.authSchemeProvider(new DpopAuthSchemeProvider());
        try {
            scb.putAuthScheme(DpopAuthScheme.create(StaticDpopIdentityProvider.create(this.dpopKeyPem)));
        }
        catch (Exception e) {
            throw SdkClientException.create((String)"Unable to refresh Login credentials. Please reauthenticate ", (Throwable)e);
        }
    }

    private static class StaticDpopIdentityProvider
    implements IdentityProvider<DpopIdentity> {
        private final DpopIdentity identity;

        private StaticDpopIdentityProvider(DpopIdentity identity) {
            this.identity = (DpopIdentity)Validate.paramNotNull((Object)identity, (String)"identity");
        }

        public static StaticDpopIdentityProvider create(String dpopKeyPem) {
            return new StaticDpopIdentityProvider(DpopIdentity.create(dpopKeyPem));
        }

        public Class<DpopIdentity> identityType() {
            return DpopIdentity.class;
        }

        public CompletableFuture<? extends DpopIdentity> resolveIdentity(ResolveIdentityRequest request) {
            return CompletableFuture.completedFuture(this.identity);
        }
    }

    private static class DpopAuthSchemeProvider
    implements SigninAuthSchemeProvider {
        private DpopAuthSchemeProvider() {
        }

        @Override
        public List<AuthSchemeOption> resolveAuthScheme(SigninAuthSchemeParams authSchemeParams) {
            return Collections.singletonList((AuthSchemeOption)AuthSchemeOption.builder().schemeId("DPOP").build());
        }
    }
}

