/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.auth;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.useragent.BusinessMetricFeatureId;
import software.amazon.awssdk.services.signin.SigninClient;
import software.amazon.awssdk.services.signin.internal.AccessTokenManager;
import software.amazon.awssdk.services.signin.internal.DpopAuthPlugin;
import software.amazon.awssdk.services.signin.internal.LoginAccessToken;
import software.amazon.awssdk.services.signin.internal.LoginCacheDirectorySystemSetting;
import software.amazon.awssdk.services.signin.internal.OnDiskTokenManager;
import software.amazon.awssdk.services.signin.model.AccessDeniedException;
import software.amazon.awssdk.services.signin.model.CreateOAuth2TokenRequest;
import software.amazon.awssdk.services.signin.model.CreateOAuth2TokenResponse;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.UserHomeDirectoryUtils;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;
import software.amazon.awssdk.utils.cache.CachedSupplier;
import software.amazon.awssdk.utils.cache.NonBlocking;
import software.amazon.awssdk.utils.cache.RefreshResult;

@SdkPublicApi
@ThreadSafe
public final class LoginCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable,
ToCopyableBuilder<Builder, LoginCredentialsProvider> {
    private static final Logger log = Logger.loggerFor(LoginCredentialsProvider.class);
    private static final String PROVIDER_NAME = BusinessMetricFeatureId.CREDENTIALS_LOGIN.value();
    private static final Duration DEFAULT_STALE_TIME = Duration.ofMinutes(1L);
    private static final Duration DEFAULT_PREFETCH_TIME = Duration.ofMinutes(5L);
    private static final Path DEFAULT_TOKEN_LOCATION = Paths.get(UserHomeDirectoryUtils.userHomeDirectory(), ".aws", "login", "cache");
    private static final String ASYNC_THREAD_NAME = "sdk-login-credentials-provider";
    private final String loginSession;
    private final String sourceChain;
    private final String providerName;
    private final SigninClient signinClient;
    private final Duration staleTime;
    private final Duration prefetchTime;
    private final Path tokenCacheLocation;
    private final CachedSupplier<AwsCredentials> credentialCache;
    private final AccessTokenManager onDiskTokenManager;
    private final Boolean asyncCredentialUpdateEnabled;

    private LoginCredentialsProvider(BuilderImpl builder) {
        this.signinClient = (SigninClient)Validate.notNull((Object)builder.signinClient, (String)"SigninClient must not be null.", (Object[])new Object[0]);
        this.loginSession = (String)Validate.paramNotBlank((CharSequence)builder.loginSession, (String)"LoginSession");
        this.staleTime = Optional.ofNullable(builder.staleTime).orElse(DEFAULT_STALE_TIME);
        this.prefetchTime = Optional.ofNullable(builder.prefetchTime).orElse(DEFAULT_PREFETCH_TIME);
        this.sourceChain = builder.sourceChain;
        this.providerName = StringUtils.isEmpty((CharSequence)builder.sourceChain) ? PROVIDER_NAME : builder.sourceChain + "," + PROVIDER_NAME;
        this.tokenCacheLocation = Optional.ofNullable(builder.tokenCacheLocation).orElseGet(() -> new LoginCacheDirectorySystemSetting().getStringValue().map(p -> Paths.get(p, new String[0])).orElse(DEFAULT_TOKEN_LOCATION));
        this.onDiskTokenManager = OnDiskTokenManager.create(this.tokenCacheLocation, this.loginSession);
        this.asyncCredentialUpdateEnabled = builder.asyncCredentialUpdateEnabled;
        CachedSupplier.Builder cacheBuilder = CachedSupplier.builder(this::updateSigninCredentials).cachedValueName(this.toString());
        if (builder.asyncCredentialUpdateEnabled.booleanValue()) {
            cacheBuilder.prefetchStrategy((CachedSupplier.PrefetchStrategy)new NonBlocking(ASYNC_THREAD_NAME));
        }
        this.credentialCache = cacheBuilder.build();
    }

    private RefreshResult<AwsCredentials> updateSigninCredentials() {
        LoginAccessToken tokenFromDisc = this.onDiskTokenManager.loadToken().orElseThrow(() -> SdkClientException.create((String)("Token cache file for login_session `" + this.loginSession + "` not found. You must re-authenticate.")));
        Instant currentExpirationTime = (Instant)tokenFromDisc.getAccessToken().expirationTime().orElseThrow(() -> SdkClientException.create((String)"Invalid token expiration time. You must re-authenticate."));
        if (LoginCredentialsProvider.shouldNotRefresh(currentExpirationTime, this.staleTime) && LoginCredentialsProvider.shouldNotRefresh(currentExpirationTime, this.prefetchTime)) {
            log.debug(() -> "Using access token from disk, current expiration time is : " + currentExpirationTime);
            AwsSessionCredentials credentials = tokenFromDisc.getAccessToken().toBuilder().providerName(this.providerName).build();
            return RefreshResult.builder((Object)credentials).staleTime(currentExpirationTime.minus(this.staleTime)).prefetchTime(currentExpirationTime.minus(this.prefetchTime)).build();
        }
        return this.refreshFromSigninService(tokenFromDisc);
    }

    private RefreshResult<AwsCredentials> refreshFromSigninService(LoginAccessToken tokenFromDisc) {
        log.debug(() -> "Credentials are near expiration/expired, refreshing from Signin service.");
        try {
            DpopAuthPlugin dpopAuthPlugin = DpopAuthPlugin.create(tokenFromDisc.getDpopKey());
            CreateOAuth2TokenRequest refreshRequest = (CreateOAuth2TokenRequest)((Object)CreateOAuth2TokenRequest.builder().tokenInput(t -> t.clientId(tokenFromDisc.getClientId()).refreshToken(tokenFromDisc.getRefreshToken()).grantType("refresh_token")).overrideConfiguration(c -> c.addPlugin(dpopAuthPlugin)).build());
            CreateOAuth2TokenResponse createTokenResponse = this.signinClient.createOAuth2Token(refreshRequest);
            Instant newExpiration = Instant.now().plusSeconds(createTokenResponse.tokenOutput().expiresIn().intValue());
            AwsSessionCredentials updatedCredentials = AwsSessionCredentials.builder().accessKeyId(createTokenResponse.tokenOutput().accessToken().accessKeyId()).secretAccessKey(createTokenResponse.tokenOutput().accessToken().secretAccessKey()).sessionToken(createTokenResponse.tokenOutput().accessToken().sessionToken()).accountId((String)tokenFromDisc.getAccessToken().accountId().orElseThrow(() -> SdkClientException.create((String)"Invalid access token, missing account ID. You must re-authenticate."))).expirationTime(newExpiration).providerName(this.providerName).build();
            this.onDiskTokenManager.storeToken(tokenFromDisc.toBuilder().accessToken(updatedCredentials).refreshToken(createTokenResponse.tokenOutput().refreshToken()).build());
            return RefreshResult.builder((Object)updatedCredentials).staleTime(newExpiration.minus(this.staleTime)).prefetchTime(newExpiration.minus(this.prefetchTime)).build();
        }
        catch (AccessDeniedException accessDeniedException) {
            if (accessDeniedException.error() == null) {
                throw accessDeniedException;
            }
            switch (accessDeniedException.error()) {
                case TOKEN_EXPIRED: {
                    throw SdkClientException.create((String)"Your session has expired. Please reauthenticate.", (Throwable)((Object)accessDeniedException));
                }
                case USER_CREDENTIALS_CHANGED: {
                    throw SdkClientException.create((String)"Unable to refresh credentials because of a change in your password. Please reauthenticate with your new password.", (Throwable)((Object)accessDeniedException));
                }
                case INSUFFICIENT_PERMISSIONS: {
                    throw SdkClientException.create((String)"Unable to refresh credentials due to insufficient permissions. You may be missing permission for the 'CreateOAuth2Token' action.", (Throwable)((Object)accessDeniedException));
                }
            }
            throw accessDeniedException;
        }
    }

    public Duration staleTime() {
        return this.staleTime;
    }

    public Duration prefetchTime() {
        return this.prefetchTime;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public AwsCredentials resolveCredentials() {
        return (AwsCredentials)this.credentialCache.get();
    }

    public void close() {
        this.credentialCache.close();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static boolean shouldNotRefresh(Instant expiration, Duration refreshWindow) {
        Instant now = Instant.now();
        return expiration.isAfter(now.plus(refreshWindow));
    }

    protected static final class BuilderImpl
    implements Builder {
        private Boolean asyncCredentialUpdateEnabled = true;
        private SigninClient signinClient;
        private Duration staleTime;
        private Duration prefetchTime;
        private String loginSession;
        private String sourceChain;
        private Path tokenCacheLocation;

        BuilderImpl() {
        }

        public BuilderImpl(LoginCredentialsProvider provider) {
            this.asyncCredentialUpdateEnabled = provider.asyncCredentialUpdateEnabled;
            this.signinClient = provider.signinClient;
            this.staleTime = provider.staleTime;
            this.prefetchTime = provider.prefetchTime;
            this.loginSession = provider.loginSession;
            this.sourceChain = provider.sourceChain;
        }

        @Override
        public Builder signinClient(SigninClient signinClient) {
            this.signinClient = signinClient;
            return this;
        }

        @Override
        public Builder asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return this;
        }

        @Override
        public Builder staleTime(Duration staleTime) {
            this.staleTime = staleTime;
            return this;
        }

        @Override
        public Builder prefetchTime(Duration prefetchTime) {
            this.prefetchTime = prefetchTime;
            return this;
        }

        @Override
        public Builder loginSession(String loginSession) {
            this.loginSession = loginSession;
            return this;
        }

        @Override
        public Builder sourceChain(String sourceChain) {
            this.sourceChain = sourceChain;
            return this;
        }

        @Override
        public Builder tokenCacheLocation(Path tokenCacheLocation) {
            this.tokenCacheLocation = tokenCacheLocation;
            return this;
        }

        @Override
        public LoginCredentialsProvider build() {
            return new LoginCredentialsProvider(this);
        }
    }

    @NotThreadSafe
    public static interface Builder
    extends CopyableBuilder<Builder, LoginCredentialsProvider> {
        public Builder signinClient(SigninClient var1);

        public Builder asyncCredentialUpdateEnabled(Boolean var1);

        public Builder staleTime(Duration var1);

        public Builder prefetchTime(Duration var1);

        public Builder loginSession(String var1);

        public Builder tokenCacheLocation(Path var1);

        @SdkInternalApi
        public Builder sourceChain(String var1);

        public LoginCredentialsProvider build();
    }
}

