/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOAuth2TokenRequestBody
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateOAuth2TokenRequestBody> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(CreateOAuth2TokenRequestBody.getter(CreateOAuth2TokenRequestBody::clientId)).setter(CreateOAuth2TokenRequestBody.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<String> GRANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("grantType").getter(CreateOAuth2TokenRequestBody.getter(CreateOAuth2TokenRequestBody::grantType)).setter(CreateOAuth2TokenRequestBody.setter(Builder::grantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantType").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(CreateOAuth2TokenRequestBody.getter(CreateOAuth2TokenRequestBody::code)).setter(CreateOAuth2TokenRequestBody.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> REDIRECT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("redirectUri").getter(CreateOAuth2TokenRequestBody.getter(CreateOAuth2TokenRequestBody::redirectUri)).setter(CreateOAuth2TokenRequestBody.setter(Builder::redirectUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectUri").build()}).build();
    private static final SdkField<String> CODE_VERIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeVerifier").getter(CreateOAuth2TokenRequestBody.getter(CreateOAuth2TokenRequestBody::codeVerifier)).setter(CreateOAuth2TokenRequestBody.setter(Builder::codeVerifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeVerifier").build()}).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("refreshToken").getter(CreateOAuth2TokenRequestBody.getter(CreateOAuth2TokenRequestBody::refreshToken)).setter(CreateOAuth2TokenRequestBody.setter(Builder::refreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, GRANT_TYPE_FIELD, CODE_FIELD, REDIRECT_URI_FIELD, CODE_VERIFIER_FIELD, REFRESH_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateOAuth2TokenRequestBody.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientId;
    private final String grantType;
    private final String code;
    private final String redirectUri;
    private final String codeVerifier;
    private final String refreshToken;

    private CreateOAuth2TokenRequestBody(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.grantType = builder.grantType;
        this.code = builder.code;
        this.redirectUri = builder.redirectUri;
        this.codeVerifier = builder.codeVerifier;
        this.refreshToken = builder.refreshToken;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String grantType() {
        return this.grantType;
    }

    public final String code() {
        return this.code;
    }

    public final String redirectUri() {
        return this.redirectUri;
    }

    public final String codeVerifier() {
        return this.codeVerifier;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantType());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeVerifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOAuth2TokenRequestBody)) {
            return false;
        }
        CreateOAuth2TokenRequestBody other = (CreateOAuth2TokenRequestBody)obj;
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.grantType(), other.grantType()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.redirectUri(), other.redirectUri()) && Objects.equals(this.codeVerifier(), other.codeVerifier()) && Objects.equals(this.refreshToken(), other.refreshToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOAuth2TokenRequestBody").add("ClientId", (Object)this.clientId()).add("GrantType", (Object)this.grantType()).add("Code", (Object)this.code()).add("RedirectUri", (Object)this.redirectUri()).add("CodeVerifier", (Object)this.codeVerifier()).add("RefreshToken", (Object)(this.refreshToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "grantType": {
                return Optional.ofNullable(clazz.cast(this.grantType()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "redirectUri": {
                return Optional.ofNullable(clazz.cast(this.redirectUri()));
            }
            case "codeVerifier": {
                return Optional.ofNullable(clazz.cast(this.codeVerifier()));
            }
            case "refreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("grantType", GRANT_TYPE_FIELD);
        map.put("code", CODE_FIELD);
        map.put("redirectUri", REDIRECT_URI_FIELD);
        map.put("codeVerifier", CODE_VERIFIER_FIELD);
        map.put("refreshToken", REFRESH_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOAuth2TokenRequestBody, T> g) {
        return obj -> g.apply((CreateOAuth2TokenRequestBody)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientId;
        private String grantType;
        private String code;
        private String redirectUri;
        private String codeVerifier;
        private String refreshToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOAuth2TokenRequestBody model) {
            this.clientId(model.clientId);
            this.grantType(model.grantType);
            this.code(model.code);
            this.redirectUri(model.redirectUri);
            this.codeVerifier(model.codeVerifier);
            this.refreshToken(model.refreshToken);
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getGrantType() {
            return this.grantType;
        }

        public final void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @Override
        public final Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getRedirectUri() {
            return this.redirectUri;
        }

        public final void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @Override
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public final String getCodeVerifier() {
            return this.codeVerifier;
        }

        public final void setCodeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
        }

        @Override
        public final Builder codeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
            return this;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public CreateOAuth2TokenRequestBody build() {
            return new CreateOAuth2TokenRequestBody(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateOAuth2TokenRequestBody> {
        public Builder clientId(String var1);

        public Builder grantType(String var1);

        public Builder code(String var1);

        public Builder redirectUri(String var1);

        public Builder codeVerifier(String var1);

        public Builder refreshToken(String var1);
    }
}

