/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signin.internal;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.Arrays;
import java.util.Base64;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.protocols.jsoncore.JsonWriter;
import software.amazon.awssdk.services.signin.internal.DpopIdentity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DpopHeaderGenerator {
    private static final int ES256_SIGNATURE_BYTE_LENGTH = 64;
    private static final byte DER_SEQUENCE_TAG = 48;

    private DpopHeaderGenerator() {
    }

    public static String generateDPoPProofHeader(DpopIdentity dpopIdentity, String endpoint, String httpMethod, long epochSeconds, String uuid) {
        Validate.paramNotNull((Object)dpopIdentity, (String)"dpopIdentity");
        Validate.paramNotBlank((CharSequence)endpoint, (String)"endpoint");
        Validate.paramNotBlank((CharSequence)httpMethod, (String)"httpMethod");
        Validate.paramNotBlank((CharSequence)uuid, (String)"uuid");
        try {
            ECPrivateKey privateKey = dpopIdentity.getPrivateKey();
            ECPublicKey publicKey = dpopIdentity.getPublicKey();
            byte[] headerJson = DpopHeaderGenerator.buildHeaderJson(publicKey);
            byte[] payloadJson = DpopHeaderGenerator.buildPayloadJson(uuid, endpoint, httpMethod, epochSeconds);
            String encodedHeader = DpopHeaderGenerator.base64UrlEncode(headerJson);
            String encodedPayload = DpopHeaderGenerator.base64UrlEncode(payloadJson);
            String message = encodedHeader + "." + encodedPayload;
            Signature signature = Signature.getInstance("SHA256withECDSA");
            signature.initSign(privateKey);
            signature.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] signatureBytes = DpopHeaderGenerator.translateDerSignatureToJws(signature.sign(), 64);
            String encodedSignature = DpopHeaderGenerator.base64UrlEncode(signatureBytes);
            return message + "." + encodedSignature;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] buildHeaderJson(ECPublicKey publicKey) {
        ECPoint pubPoint = publicKey.getW();
        String x = DpopHeaderGenerator.base64UrlEncode(DpopHeaderGenerator.stripLeadingZero(pubPoint.getAffineX().toByteArray()));
        String y = DpopHeaderGenerator.base64UrlEncode(DpopHeaderGenerator.stripLeadingZero(pubPoint.getAffineY().toByteArray()));
        try (JsonWriter jsonWriter = null;){
            jsonWriter = JsonWriter.create();
            jsonWriter.writeStartObject();
            jsonWriter.writeFieldName("typ");
            jsonWriter.writeValue("dpop+jwt");
            jsonWriter.writeFieldName("alg");
            jsonWriter.writeValue("ES256");
            jsonWriter.writeFieldName("jwk");
            jsonWriter.writeStartObject();
            jsonWriter.writeFieldName("crv");
            jsonWriter.writeValue("P-256");
            jsonWriter.writeFieldName("kty");
            jsonWriter.writeValue("EC");
            jsonWriter.writeFieldName("x");
            jsonWriter.writeValue(x);
            jsonWriter.writeFieldName("y");
            jsonWriter.writeValue(y);
            jsonWriter.writeEndObject();
            jsonWriter.writeEndObject();
            byte[] byArray = jsonWriter.getBytes();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] buildPayloadJson(String uuid, String endpoint, String httpMethod, long epochSeconds) {
        try (JsonWriter jsonWriter = null;){
            jsonWriter = JsonWriter.create();
            jsonWriter.writeStartObject();
            jsonWriter.writeFieldName("jti");
            jsonWriter.writeValue(uuid);
            jsonWriter.writeFieldName("htm");
            jsonWriter.writeValue(httpMethod);
            jsonWriter.writeFieldName("htu");
            jsonWriter.writeValue(endpoint);
            jsonWriter.writeFieldName("iat");
            jsonWriter.writeValue(epochSeconds);
            jsonWriter.writeEndObject();
            byte[] byArray = jsonWriter.getBytes();
            return byArray;
        }
    }

    private static byte[] translateDerSignatureToJws(byte[] derSignature, int outputLength) {
        int j;
        int i;
        int offset;
        if (derSignature.length < 8 || derSignature[0] != 48) {
            throw new RuntimeException("Invalid ECDSA signature format");
        }
        if (derSignature[1] > 0) {
            offset = 2;
        } else if (derSignature[1] == -127) {
            offset = 3;
        } else {
            throw new RuntimeException("Invalid ECDSA signature format");
        }
        int rLength = derSignature[offset + 1];
        int endOfR = offset + 2 + rLength;
        for (i = rLength; i > 0 && derSignature[endOfR - i] == 0; --i) {
        }
        int sLength = derSignature[endOfR + 1];
        int endOfS = endOfR + 2 + sLength;
        for (j = sLength; j > 0 && derSignature[endOfS - j] == 0; --j) {
        }
        int rawLen = Math.max(i, j);
        rawLen = Math.max(rawLen, outputLength / 2);
        if ((derSignature[offset - 1] & 0xFF) != derSignature.length - offset || (derSignature[offset - 1] & 0xFF) != 2 + rLength + 2 + sLength || derSignature[offset] != 2 || derSignature[endOfR] != 2) {
            throw new RuntimeException("Invalid ECDSA signature format");
        }
        byte[] jwsSignature = new byte[2 * rawLen];
        System.arraycopy(derSignature, endOfR - i, jwsSignature, rawLen - i, i);
        System.arraycopy(derSignature, offset + 2 + rLength + 2 + sLength - j, jwsSignature, 2 * rawLen - j, j);
        return jwsSignature;
    }

    private static String base64UrlEncode(byte[] data) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(data);
    }

    private static byte[] stripLeadingZero(byte[] bytes) {
        if (bytes.length > 1 && bytes[0] == 0) {
            return Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        return bytes;
    }
}

